/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.rubinius.DirLayout;

public class DirLayoutImpl
extends BasicObjectLayoutImpl
implements DirLayout {
    public static final DirLayout INSTANCE = new DirLayoutImpl();
    protected static final Shape.Allocator DIR_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey CONTENTS_IDENTIFIER = new HiddenKey("contents");
    protected static final Property CONTENTS_PROPERTY = Property.create(CONTENTS_IDENTIFIER, DIR_ALLOCATOR.locationForType(Object.class), 0);
    protected static final HiddenKey POSITION_IDENTIFIER = new HiddenKey("position");
    protected static final Property POSITION_PROPERTY = Property.create(POSITION_IDENTIFIER, DIR_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);

    protected DirLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createDirShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new DirType(logicalClass, metaClass)).addProperty(CONTENTS_PROPERTY).addProperty(POSITION_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createDir(DynamicObjectFactory factory, Object contents, int position) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsDir(factory));
        assert (factory.getShape().hasProperty(CONTENTS_IDENTIFIER));
        assert (factory.getShape().hasProperty(POSITION_IDENTIFIER));
        return factory.newInstance(contents, position);
    }

    private boolean isDir(DynamicObject object) {
        return this.isDir(object.getShape().getObjectType());
    }

    private boolean isDir(ObjectType objectType) {
        return objectType instanceof DirType;
    }

    private boolean createsDir(DynamicObjectFactory factory) {
        return this.isDir(factory.getShape().getObjectType());
    }

    @Override
    public Object getContents(DynamicObject object) {
        assert (this.isDir(object));
        assert (object.getShape().hasProperty(CONTENTS_IDENTIFIER));
        return CONTENTS_PROPERTY.get(object, true);
    }

    @Override
    public void setContents(DynamicObject object, Object value) {
        assert (this.isDir(object));
        assert (object.getShape().hasProperty(CONTENTS_IDENTIFIER));
        try {
            CONTENTS_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public int getPosition(DynamicObject object) {
        assert (this.isDir(object));
        assert (object.getShape().hasProperty(POSITION_IDENTIFIER));
        return (Integer)POSITION_PROPERTY.get(object, true);
    }

    @Override
    public void setPosition(DynamicObject object, int value) {
        assert (this.isDir(object));
        assert (object.getShape().hasProperty(POSITION_IDENTIFIER));
        try {
            POSITION_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class DirType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public DirType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public DirType setLogicalClass(DynamicObject logicalClass) {
            return new DirType(logicalClass, this.metaClass);
        }

        @Override
        public DirType setMetaClass(DynamicObject metaClass) {
            return new DirType(this.logicalClass, metaClass);
        }
    }
}

