#ifndef EFL_GENERATED_ELM_INTERFACE_SCROLLABLE_HH
#define EFL_GENERATED_ELM_INTERFACE_SCROLLABLE_HH

extern "C"
{
#include <Efl.h>
}
#include <Eo.hh>

#include <eo_cxx_interop.hh>

extern "C"
{
#include "elm_interface_scrollable.eo.h"
}

#include "evas_scrollable_interface.eo.hh"
#include "evas_object_smart.eo.hh"
#include <evas_object.eo.hh>

struct elm_interface_scrollable;

/// @cond EO_CXX_ABSTRACT
namespace eo_cxx {

struct elm_interface_scrollable
{
   /// @param x 
   /// @param y 
   /// @param sig 
   ///
   void content_pos_set(Evas_Coord x_, Evas_Coord y_, bool sig_) const;

   /// @param[out] x 
   /// @param[out] y 
   ///
   void content_pos_get(Evas_Coord* x_, Evas_Coord* y_) const;

   /// @param pagenumber_h 
   /// @param pagenumber_v 
   ///
   void page_show(int pagenumber_h_, int pagenumber_v_) const;

   /// @param x 
   /// @param y 
   /// @param w 
   /// @param h 
   ///
   void region_bring_in(Evas_Coord x_, Evas_Coord y_, Evas_Coord w_, Evas_Coord h_) const;

   /// @param pagenumber_h 
   /// @param pagenumber_v 
   ///
   void page_bring_in(int pagenumber_h_, int pagenumber_v_) const;

   /// @param x 
   /// @param y 
   /// @param w 
   /// @param h 
   ///
   void content_region_show(Evas_Coord x_, Evas_Coord y_, Evas_Coord w_, Evas_Coord h_) const;

   /// @param w 
   /// @param h 
   ///
   void content_min_limit(bool w_, bool h_) const;

   void gravity_get(double* x_, double* y_) const;

   void gravity_set(double x_, double y_) const;

   void bounce_allow_get(Eina_Bool* horiz_, Eina_Bool* vert_) const;

   void bounce_allow_set(bool horiz_, bool vert_) const;

   bool wheel_disabled_get() const;

   void wheel_disabled_set(bool disabled_) const;

   Elm_Scroller_Movement_Block movement_block_get() const;

   void movement_block_set(Elm_Scroller_Movement_Block block_) const;

   bool momentum_animator_disabled_get() const;

   void momentum_animator_disabled_set(bool disabled_) const;

   void policy_get(Elm_Scroller_Policy* hbar_, Elm_Scroller_Policy* vbar_) const;

   void policy_set(Elm_Scroller_Policy hbar_, Elm_Scroller_Policy vbar_) const;

   void content_region_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   void content_region_set(Evas_Coord x_, Evas_Coord y_, Evas_Coord w_, Evas_Coord h_) const;

   bool repeat_events_get() const;

   void repeat_events_set(bool repeat_events_) const;

   void page_size_get(Evas_Coord* x_, Evas_Coord* y_) const;

   void page_size_set(Evas_Coord x_, Evas_Coord y_) const;

   bool bounce_animator_disabled_get() const;

   void bounce_animator_disabled_set(bool disabled_) const;

   void page_scroll_limit_get(int* page_limit_h_, int* page_limit_v_) const;

   void page_scroll_limit_set(int page_limit_h_, int page_limit_v_) const;

   void page_snap_allow_get(Eina_Bool* horiz_, Eina_Bool* vert_) const;

   void page_snap_allow_set(bool horiz_, bool vert_) const;

   void paging_get(double* pagerel_h_, double* pagerel_v_, Evas_Coord* pagesize_h_, Evas_Coord* pagesize_v_) const;

   void paging_set(double pagerel_h_, double pagerel_v_, Evas_Coord pagesize_h_, Evas_Coord pagesize_v_) const;

   Elm_Scroller_Single_Direction single_direction_get() const;

   void single_direction_set(Elm_Scroller_Single_Direction single_dir_) const;

   void step_size_get(Evas_Coord* x_, Evas_Coord* y_) const;

   void step_size_set(Evas_Coord x_, Evas_Coord y_) const;

   void loop_get(Eina_Bool* loop_h_, Eina_Bool* loop_v_) const;

   void loop_set(bool loop_h_, bool loop_v_) const;

   void scroll_up_cb_set(Elm_Interface_Scrollable_Cb scroll_up_cb_) const;

   void hbar_drag_cb_set(Elm_Interface_Scrollable_Cb hbar_drag_cb_) const;

   void drag_start_cb_set(Elm_Interface_Scrollable_Cb drag_start_cb_) const;

   void freeze_set(bool freeze_) const;

   void content_viewport_resize_cb_set(Elm_Interface_Scrollable_Resize_Cb viewport_resize_cb_) const;

   void scroll_left_cb_set(Elm_Interface_Scrollable_Cb scroll_left_cb_) const;

   void vbar_press_cb_set(Elm_Interface_Scrollable_Cb vbar_press_cb_) const;

   void hbar_press_cb_set(Elm_Interface_Scrollable_Cb hbar_press_cb_) const;

   void hbar_unpress_cb_set(Elm_Interface_Scrollable_Cb hbar_unpress_cb_) const;

   void drag_stop_cb_set(Elm_Interface_Scrollable_Cb drag_stop_cb_) const;

   void extern_pan_set(::evas::object pan_) const;

   void page_change_cb_set(Elm_Interface_Scrollable_Cb page_change_cb_) const;

   void hold_set(bool hold_) const;

   void animate_start_cb_set(Elm_Interface_Scrollable_Cb animate_start_cb_) const;

   void scroll_down_cb_set(Elm_Interface_Scrollable_Cb scroll_down_cb_) const;

   void page_relative_set(double h_pagerel_, double v_pagerel_) const;

   void scroll_cb_set(Elm_Interface_Scrollable_Cb scroll_cb_) const;

   void animate_stop_cb_set(Elm_Interface_Scrollable_Cb animate_stop_cb_) const;

   void mirrored_set(bool mirrored_) const;

   void content_min_limit_cb_set(Elm_Interface_Scrollable_Min_Limit_Cb min_limit_cb_) const;

   void scroll_right_cb_set(Elm_Interface_Scrollable_Cb scroll_right_cb_) const;

   void content_set(::evas::object content_) const;

   void edge_left_cb_set(Elm_Interface_Scrollable_Cb edge_left_cb_) const;

   void vbar_drag_cb_set(Elm_Interface_Scrollable_Cb vbar_drag_cb_) const;

   void vbar_unpress_cb_set(Elm_Interface_Scrollable_Cb vbar_unpress_cb_) const;

   void edge_bottom_cb_set(Elm_Interface_Scrollable_Cb edge_bottom_cb_) const;

   void edge_right_cb_set(Elm_Interface_Scrollable_Cb edge_right_cb_) const;

   void edge_top_cb_set(Elm_Interface_Scrollable_Cb edge_top_cb_) const;

   void objects_set(::evas::object edje_object_, ::evas::object hit_rectangle_) const;

   void last_page_get(int* pagenumber_h_, int* pagenumber_v_) const;

   void current_page_get(int* pagenumber_h_, int* pagenumber_v_) const;

   void content_viewport_geometry_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   void content_size_get(Evas_Coord* w_, Evas_Coord* h_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_SCROLLABLE_EVENT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         ELM_INTERFACE_SCROLLABLE_EVENT_CHANGED );
   }

   template <typename T>
   void
   callback_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_SCROLLABLE_EVENT_CHANGED, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_INTERFACE_SCROLLABLE_MIXIN);
   }

   operator ::elm_interface_scrollable() const;
   operator ::elm_interface_scrollable&();
   operator ::elm_interface_scrollable const&() const;

   /// @cond LOCAL
   template <typename D>
   struct address_of
   {
      operator ::elm_interface_scrollable*() const { return static_cast<::elm_interface_scrollable*>(static_cast<D const*>(this)->p); }
      operator ::elm_interface_scrollable const*() const { return static_cast<::elm_interface_scrollable const*>(static_cast<D const*>(this)->p); }
   };

   template <typename D>
   struct address_const_of
   {
      operator ::elm_interface_scrollable const*() const { return static_cast<::elm_interface_scrollable const*>(static_cast<D const*>(this)->p); }
   };
   /// @endcond

private:

   /// @internal
   Eo* _concrete_eo_ptr() const
   {
      return static_cast<::efl::eo::concrete const*>(static_cast<void const*>(this))->_eo_ptr();
   }

};

}
/// @endcond

/// @brief Class elm_interface_scrollable
struct elm_interface_scrollable
      : ::efl::eo::concrete
      , EO_CXX_INHERIT(efl::gfx::base)
      , EO_CXX_INHERIT(efl::gfx::stack)
      , EO_CXX_INHERIT(eo::base)
      , EO_CXX_INHERIT(evas::common_interface)
      , EO_CXX_INHERIT(evas::object)
      , EO_CXX_INHERIT(evas::object_smart)
      , EO_CXX_INHERIT(evas::scrollable_interface)
      , EO_CXX_INHERIT(evas::signal_interface)
{
   //@{
   /**
      @brief Constructs a new elm_interface_scrollable object.

      Constructs a new elm_interface_scrollable object. If you want this object to be a child
      of another Eo object, use an @ref efl::eo::parent expression, like the example.

      Example:
      @code
      elm_interface_scrollable my_elm_interface_scrollable(efl::eo::parent = parent_object);
      @endcode

      @see elm_interface_scrollable(Eo* eo)
   */
   explicit elm_interface_scrollable(::efl::eo::parent_type _p)
      : elm_interface_scrollable(_ctors_call(_p))
   {}

   explicit elm_interface_scrollable()
      : elm_interface_scrollable(_ctors_call(::efl::eo::parent = nullptr))
   {}
   //@}

   /// @brief Eo Constructor.
   ///
   /// Constructs the object from an Eo* pointer stealing its ownership.
   ///
   /// @param eo The Eo object pointer.
   ///
   explicit elm_interface_scrollable(Eo* eo)
      : ::efl::eo::concrete(eo)
   {}

   /// @brief nullptr_t Constructor.
   ///
   /// Constructs an empty (null) object.
   ///
   explicit elm_interface_scrollable(std::nullptr_t)
      : ::efl::eo::concrete(nullptr)
   {}

   /// @brief Copy Constructor.
   ///
   elm_interface_scrollable(elm_interface_scrollable const& other)
      : elm_interface_scrollable(eo_ref(other._eo_ptr()))
   {}

   ~elm_interface_scrollable() {}

   /// @param x 
   /// @param y 
   /// @param sig 
   ///
   void content_pos_set(Evas_Coord x_, Evas_Coord y_, bool sig_) const;

   /// @param[out] x 
   /// @param[out] y 
   ///
   void content_pos_get(Evas_Coord* x_, Evas_Coord* y_) const;

   /// @param pagenumber_h 
   /// @param pagenumber_v 
   ///
   void page_show(int pagenumber_h_, int pagenumber_v_) const;

   /// @param x 
   /// @param y 
   /// @param w 
   /// @param h 
   ///
   void region_bring_in(Evas_Coord x_, Evas_Coord y_, Evas_Coord w_, Evas_Coord h_) const;

   /// @param pagenumber_h 
   /// @param pagenumber_v 
   ///
   void page_bring_in(int pagenumber_h_, int pagenumber_v_) const;

   /// @param x 
   /// @param y 
   /// @param w 
   /// @param h 
   ///
   void content_region_show(Evas_Coord x_, Evas_Coord y_, Evas_Coord w_, Evas_Coord h_) const;

   /// @param w 
   /// @param h 
   ///
   void content_min_limit(bool w_, bool h_) const;

   void gravity_get(double* x_, double* y_) const;

   void gravity_set(double x_, double y_) const;

   void bounce_allow_get(Eina_Bool* horiz_, Eina_Bool* vert_) const;

   void bounce_allow_set(bool horiz_, bool vert_) const;

   bool wheel_disabled_get() const;

   void wheel_disabled_set(bool disabled_) const;

   Elm_Scroller_Movement_Block movement_block_get() const;

   void movement_block_set(Elm_Scroller_Movement_Block block_) const;

   bool momentum_animator_disabled_get() const;

   void momentum_animator_disabled_set(bool disabled_) const;

   void policy_get(Elm_Scroller_Policy* hbar_, Elm_Scroller_Policy* vbar_) const;

   void policy_set(Elm_Scroller_Policy hbar_, Elm_Scroller_Policy vbar_) const;

   void content_region_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   void content_region_set(Evas_Coord x_, Evas_Coord y_, Evas_Coord w_, Evas_Coord h_) const;

   bool repeat_events_get() const;

   void repeat_events_set(bool repeat_events_) const;

   void page_size_get(Evas_Coord* x_, Evas_Coord* y_) const;

   void page_size_set(Evas_Coord x_, Evas_Coord y_) const;

   bool bounce_animator_disabled_get() const;

   void bounce_animator_disabled_set(bool disabled_) const;

   void page_scroll_limit_get(int* page_limit_h_, int* page_limit_v_) const;

   void page_scroll_limit_set(int page_limit_h_, int page_limit_v_) const;

   void page_snap_allow_get(Eina_Bool* horiz_, Eina_Bool* vert_) const;

   void page_snap_allow_set(bool horiz_, bool vert_) const;

   void paging_get(double* pagerel_h_, double* pagerel_v_, Evas_Coord* pagesize_h_, Evas_Coord* pagesize_v_) const;

   void paging_set(double pagerel_h_, double pagerel_v_, Evas_Coord pagesize_h_, Evas_Coord pagesize_v_) const;

   Elm_Scroller_Single_Direction single_direction_get() const;

   void single_direction_set(Elm_Scroller_Single_Direction single_dir_) const;

   void step_size_get(Evas_Coord* x_, Evas_Coord* y_) const;

   void step_size_set(Evas_Coord x_, Evas_Coord y_) const;

   void loop_get(Eina_Bool* loop_h_, Eina_Bool* loop_v_) const;

   void loop_set(bool loop_h_, bool loop_v_) const;

   void scroll_up_cb_set(Elm_Interface_Scrollable_Cb scroll_up_cb_) const;

   void hbar_drag_cb_set(Elm_Interface_Scrollable_Cb hbar_drag_cb_) const;

   void drag_start_cb_set(Elm_Interface_Scrollable_Cb drag_start_cb_) const;

   void freeze_set(bool freeze_) const;

   void content_viewport_resize_cb_set(Elm_Interface_Scrollable_Resize_Cb viewport_resize_cb_) const;

   void scroll_left_cb_set(Elm_Interface_Scrollable_Cb scroll_left_cb_) const;

   void vbar_press_cb_set(Elm_Interface_Scrollable_Cb vbar_press_cb_) const;

   void hbar_press_cb_set(Elm_Interface_Scrollable_Cb hbar_press_cb_) const;

   void hbar_unpress_cb_set(Elm_Interface_Scrollable_Cb hbar_unpress_cb_) const;

   void drag_stop_cb_set(Elm_Interface_Scrollable_Cb drag_stop_cb_) const;

   void extern_pan_set(::evas::object pan_) const;

   void page_change_cb_set(Elm_Interface_Scrollable_Cb page_change_cb_) const;

   void hold_set(bool hold_) const;

   void animate_start_cb_set(Elm_Interface_Scrollable_Cb animate_start_cb_) const;

   void scroll_down_cb_set(Elm_Interface_Scrollable_Cb scroll_down_cb_) const;

   void page_relative_set(double h_pagerel_, double v_pagerel_) const;

   void scroll_cb_set(Elm_Interface_Scrollable_Cb scroll_cb_) const;

   void animate_stop_cb_set(Elm_Interface_Scrollable_Cb animate_stop_cb_) const;

   void mirrored_set(bool mirrored_) const;

   void content_min_limit_cb_set(Elm_Interface_Scrollable_Min_Limit_Cb min_limit_cb_) const;

   void scroll_right_cb_set(Elm_Interface_Scrollable_Cb scroll_right_cb_) const;

   void content_set(::evas::object content_) const;

   void edge_left_cb_set(Elm_Interface_Scrollable_Cb edge_left_cb_) const;

   void vbar_drag_cb_set(Elm_Interface_Scrollable_Cb vbar_drag_cb_) const;

   void vbar_unpress_cb_set(Elm_Interface_Scrollable_Cb vbar_unpress_cb_) const;

   void edge_bottom_cb_set(Elm_Interface_Scrollable_Cb edge_bottom_cb_) const;

   void edge_right_cb_set(Elm_Interface_Scrollable_Cb edge_right_cb_) const;

   void edge_top_cb_set(Elm_Interface_Scrollable_Cb edge_top_cb_) const;

   void objects_set(::evas::object edje_object_, ::evas::object hit_rectangle_) const;

   void last_page_get(int* pagenumber_h_, int* pagenumber_v_) const;

   void current_page_get(int* pagenumber_h_, int* pagenumber_v_) const;

   void content_viewport_geometry_get(Evas_Coord* x_, Evas_Coord* y_, Evas_Coord* w_, Evas_Coord* h_) const;

   void content_size_get(Evas_Coord* w_, Evas_Coord* h_) const;

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_add_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_ADD, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EO_BASE_EVENT_CALLBACK_ADD );
   }

   template <typename T>
   void
   callback_callback_add_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_ADD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_callback_del_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EO_BASE_EVENT_CALLBACK_DEL, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EO_BASE_EVENT_CALLBACK_DEL );
   }

   template <typename T>
   void
   callback_callback_del_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EO_BASE_EVENT_CALLBACK_DEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (ELM_INTERFACE_SCROLLABLE_EVENT_CHANGED, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         ELM_INTERFACE_SCROLLABLE_EVENT_CHANGED );
   }

   template <typename T>
   void
   callback_changed_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (ELM_INTERFACE_SCROLLABLE_EVENT_CHANGED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_changed_size_hints_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS );
   }

   template <typename T>
   void
   callback_changed_size_hints_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_CHANGED_SIZE_HINTS, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focus_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FOCUS_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_FOCUS_IN );
   }

   template <typename T>
   void
   callback_focus_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FOCUS_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_focus_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FOCUS_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_FOCUS_OUT );
   }

   template <typename T>
   void
   callback_focus_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FOCUS_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_free_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_FREE, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_FREE );
   }

   template <typename T>
   void
   callback_free_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_FREE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_hide_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_HIDE, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_HIDE );
   }

   template <typename T>
   void
   callback_hide_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_HIDE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_hold_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_HOLD, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_HOLD );
   }

   template <typename T>
   void
   callback_hold_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_HOLD, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_preloaded_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_PRELOADED, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_PRELOADED );
   }

   template <typename T>
   void
   callback_image_preloaded_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_PRELOADED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_resize_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_RESIZE, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_RESIZE );
   }

   template <typename T>
   void
   callback_image_resize_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_RESIZE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_image_unloaded_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_IMAGE_UNLOADED, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_IMAGE_UNLOADED );
   }

   template <typename T>
   void
   callback_image_unloaded_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_IMAGE_UNLOADED, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_key_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_KEY_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_KEY_DOWN );
   }

   template <typename T>
   void
   callback_key_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_KEY_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_key_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_KEY_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_KEY_UP );
   }

   template <typename T>
   void
   callback_key_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_KEY_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_DOWN );
   }

   template <typename T>
   void
   callback_mouse_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_in_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_IN, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_IN );
   }

   template <typename T>
   void
   callback_mouse_in_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_IN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_MOVE );
   }

   template <typename T>
   void
   callback_mouse_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_out_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_OUT, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_OUT );
   }

   template <typename T>
   void
   callback_mouse_out_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_OUT, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_UP );
   }

   template <typename T>
   void
   callback_mouse_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_mouse_wheel_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOUSE_WHEEL, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MOUSE_WHEEL );
   }

   template <typename T>
   void
   callback_mouse_wheel_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOUSE_WHEEL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MOVE );
   }

   template <typename T>
   void
   callback_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_down_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_DOWN, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MULTI_DOWN );
   }

   template <typename T>
   void
   callback_multi_down_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_DOWN, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_move_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_MOVE, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MULTI_MOVE );
   }

   template <typename T>
   void
   callback_multi_move_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_MOVE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_multi_up_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_MULTI_UP, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_MULTI_UP );
   }

   template <typename T>
   void
   callback_multi_up_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_MULTI_UP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_resize_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_RESIZE, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_RESIZE );
   }

   template <typename T>
   void
   callback_resize_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_RESIZE, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_restack_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_RESTACK, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_RESTACK );
   }

   template <typename T>
   void
   callback_restack_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_RESTACK, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL );
   }

   template <typename T>
   void
   callback_scroll_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_anim_start_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_START, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_START );
   }

   template <typename T>
   void
   callback_scroll_anim_start_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_START, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_anim_stop_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_STOP, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_STOP );
   }

   template <typename T>
   void
   callback_scroll_anim_stop_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_ANIM_STOP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_drag_start_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_START, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_START );
   }

   template <typename T>
   void
   callback_scroll_drag_start_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_START, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_scroll_drag_stop_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_STOP, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_STOP );
   }

   template <typename T>
   void
   callback_scroll_drag_stop_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_SCROLLABLE_INTERFACE_EVENT_SCROLL_DRAG_STOP, info));
   }

   template <typename F>
   ::efl::eo::signal_connection
   callback_show_add(F && callback_,
                        ::efl::eo::callback_priority priority_ =
                        ::efl::eo::callback_priorities::default_)
   {
      typedef typename std::remove_reference<F>::type function_type;
      ::std::unique_ptr<function_type> f ( new function_type(std::forward<F>(callback_)) );
      eo_do(_concrete_eo_ptr(),
            eo_event_callback_priority_add
            (EVAS_OBJECT_EVENT_SHOW, priority_,
            &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>, f.get()));
      return ::efl::eo::make_signal_connection
         (f, _concrete_eo_ptr(), &::efl::eo::_detail::event_callback<::elm_interface_scrollable, function_type>,
         EVAS_OBJECT_EVENT_SHOW );
   }

   template <typename T>
   void
   callback_show_call(T* info)
   {
      eo_do(_concrete_eo_ptr(), eo_event_callback_call
            (EVAS_OBJECT_EVENT_SHOW, info));
   }



   static Eo_Class const* _eo_class()
   {
      return(ELM_INTERFACE_SCROLLABLE_MIXIN);
   }

   /// @cond LOCAL
   struct address_of
      : ::eo_cxx::elm_interface_scrollable::address_of<address_of>
      , ::eo_cxx::efl::gfx::base::address_of<address_of>
      , ::eo_cxx::efl::gfx::stack::address_of<address_of>
      , ::eo_cxx::eo::base::address_of<address_of>
      , ::eo_cxx::evas::common_interface::address_of<address_of>
      , ::eo_cxx::evas::object::address_of<address_of>
      , ::eo_cxx::evas::object_smart::address_of<address_of>
      , ::eo_cxx::evas::scrollable_interface::address_of<address_of>
      , ::eo_cxx::evas::signal_interface::address_of<address_of>
      , ::efl::eo::detail::concrete_address_of
   {
      explicit address_of(::elm_interface_scrollable* p)
         : ::efl::eo::detail::concrete_address_of(p)
      {}
   };
   address_of operator&() { return address_of(this); }

   struct address_const_of
      : ::eo_cxx::elm_interface_scrollable::address_const_of<address_const_of>
      , ::eo_cxx::efl::gfx::base::address_const_of<address_const_of>
      , ::eo_cxx::efl::gfx::stack::address_const_of<address_const_of>
      , ::eo_cxx::eo::base::address_const_of<address_const_of>
      , ::eo_cxx::evas::common_interface::address_const_of<address_const_of>
      , ::eo_cxx::evas::object::address_const_of<address_const_of>
      , ::eo_cxx::evas::object_smart::address_const_of<address_const_of>
      , ::eo_cxx::evas::scrollable_interface::address_const_of<address_const_of>
      , ::eo_cxx::evas::signal_interface::address_const_of<address_const_of>
      , ::efl::eo::detail::concrete_address_const_of
   {
      explicit address_const_of(::elm_interface_scrollable const* p)
         : ::efl::eo::detail::concrete_address_const_of(p)
      {}
   };
   address_const_of operator&() const { return address_const_of(this); }

   /// @endcond

private:

   /// @internal
   static Eo* _ctors_call(::efl::eo::parent_type _p)
   {
      Eo* _ret_eo = eo_add_ref(ELM_INTERFACE_SCROLLABLE_MIXIN, _p._eo_raw);

      return _ret_eo;
   }

   /// @internal
   Eo* _concrete_eo_ptr() const { return _eo_ptr(); }
};

static_assert(sizeof(::elm_interface_scrollable) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<::elm_interface_scrollable>::value, "");


#include "elm_interface_scrollable.eo.impl.hh"

#endif // EFL_GENERATED_ELM_INTERFACE_SCROLLABLE_HH

