/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scope;
import com.google.inject.Scopes;

public class SingletonScope
implements Scope {
    private static final Object NULL = new Object();

    @Override
    public <T> Provider<T> scope(Key<T> key, final Provider<T> creator) {
        return new Provider<T>(){
            private volatile Object instance;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                Object localInstance;
                if (this.instance == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.instance == null) {
                            Object providedOrSentinel;
                            Object provided = creator.get();
                            if (Scopes.isCircularProxy(provided)) {
                                return provided;
                            }
                            Object object = providedOrSentinel = provided == null ? NULL : provided;
                            if (this.instance != null && this.instance != providedOrSentinel) {
                                throw new ProvisionException("Provider was reentrant while creating a singleton");
                            }
                            this.instance = providedOrSentinel;
                        }
                    }
                }
                Object returnedInstance = (localInstance = this.instance) != NULL ? localInstance : null;
                return returnedInstance;
            }

            public String toString() {
                return String.format("%s[%s]", creator, Scopes.SINGLETON);
            }
        };
    }

    @Override
    public String toString() {
        return "Scopes.SINGLETON";
    }
}

