"use strict";

var _regeneratorRuntime = require("babel-runtime/regenerator")["default"];

var _Promise = require("babel-runtime/core-js/promise")["default"];

var _getIterator = require("babel-runtime/core-js/get-iterator")["default"];

var _interopRequireDefault = require("babel-runtime/helpers/interop-require-default")["default"];

var _interopRequireWildcard = require("babel-runtime/helpers/interop-require-wildcard")["default"];

var _chalk = require("chalk");

var _chalk2 = _interopRequireDefault(_chalk);

var _path = require("path");

var _path2 = _interopRequireDefault(_path);

var _fs = require("fs");

var _fs2 = _interopRequireDefault(_fs);

var _rules = require("./rules");

var rules = _interopRequireWildcard(_rules);

var _logSymbols = require("log-symbols");

var _logSymbols2 = _interopRequireDefault(_logSymbols);

var didError = false;
var lastWasSep = false;

function sep() {
  if (lastWasSep) return;
  lastWasSep = true;

  console.log();
}

function log(msg) {
  lastWasSep = false;
  console.log(msg);
}

//

log("\n" + _chalk2["default"].underline.yellow("Babel Doctor"));
log("Running sanity checks on your system. This may take a few minutes...\n");

//

var packages = [];

var nodeModulesDirectories = [_path2["default"].join(process.cwd(), "node_modules")];

while (nodeModulesDirectories.length) {
  var loc = nodeModulesDirectories.shift();
  if (!_fs2["default"].existsSync(loc)) continue;

  var packagesNames = _fs2["default"].readdirSync(loc);

  for (var _i = 0; _i < packagesNames.length; _i++) {
    var packageName = packagesNames[_i];
    if (packageName[0] === ".") continue;

    var packageLoc = _path2["default"].join(loc, packageName);
    var packageJsonLoc = _path2["default"].join(packageLoc, "package.json");
    if (!_fs2["default"].existsSync(packageJsonLoc)) continue;

    packages.push({
      name: packageName,
      loc: packageLoc,
      version: require(packageJsonLoc).version
    });

    nodeModulesDirectories.push(_path2["default"].join(packageLoc, "node_modules"));
  }
}

//

function run() {
  var promises, key, fn, results, _iterator, _isArray, _i2, _ref, success, message, multiline;

  return _regeneratorRuntime.async(function run$(context$1$0) {
    while (1) switch (context$1$0.prev = context$1$0.next) {
      case 0:
        promises = [];
        context$1$0.t0 = _regeneratorRuntime.keys(rules);

      case 2:
        if ((context$1$0.t1 = context$1$0.t0()).done) {
          context$1$0.next = 10;
          break;
        }

        key = context$1$0.t1.value;

        if (!(key[0] === "_")) {
          context$1$0.next = 6;
          break;
        }

        return context$1$0.abrupt("continue", 2);

      case 6:
        fn = rules[key];

        promises.push(fn(packages));
        context$1$0.next = 2;
        break;

      case 10:
        context$1$0.next = 12;
        return _regeneratorRuntime.awrap(_Promise.all(promises));

      case 12:
        results = context$1$0.sent;
        _iterator = results, _isArray = Array.isArray(_iterator), _i2 = 0, _iterator = _isArray ? _iterator : _getIterator(_iterator);

      case 14:
        if (!_isArray) {
          context$1$0.next = 20;
          break;
        }

        if (!(_i2 >= _iterator.length)) {
          context$1$0.next = 17;
          break;
        }

        return context$1$0.abrupt("break", 33);

      case 17:
        _ref = _iterator[_i2++];
        context$1$0.next = 24;
        break;

      case 20:
        _i2 = _iterator.next();

        if (!_i2.done) {
          context$1$0.next = 23;
          break;
        }

        return context$1$0.abrupt("break", 33);

      case 23:
        _ref = _i2.value;

      case 24:
        success = _ref[0];
        message = _ref[1];

        if (!success) didError = true;
        multiline = message.indexOf("\n") >= 0;

        if (multiline) sep();
        log((success ? _logSymbols2["default"].success : _logSymbols2["default"].error) + " " + message);
        if (multiline) sep();

      case 31:
        context$1$0.next = 14;
        break;

      case 33:

        sep();

        if (didError) {
          log(_chalk2["default"].red("Found potential issues on your machine :("));
        } else {
          log(_chalk2["default"].green("Everything looks all right!"));
        }

        sep();

      case 36:
      case "end":
        return context$1$0.stop();
    }
  }, null, this);
}

run().then(function () {
  process.exit(0);
}, function (err) {
  console.error(err.stack);
  process.exit(1);
});