/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DigesterOutputStream
extends ByteArrayOutputStream {
    final MessageDigestAlgorithm mda;
    static Logger log = Logger.getLogger(DigesterOutputStream.class.getName());

    public DigesterOutputStream(MessageDigestAlgorithm mda) {
        this.mda = mda;
    }

    @Override
    public void write(byte[] arg0) {
        this.write(arg0, 0, arg0.length);
    }

    @Override
    public void write(int arg0) {
        this.mda.update((byte)arg0);
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Pre-digested input:");
            StringBuffer sb = new StringBuffer(arg2);
            for (int i = arg1; i < arg1 + arg2; ++i) {
                sb.append((char)arg0[i]);
            }
            log.log(Level.FINE, sb.toString());
        }
        this.mda.update(arg0, arg1, arg2);
    }

    public byte[] getDigestValue() {
        return this.mda.digest();
    }
}

