/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XOMOrientation
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 8;
    }

    @Override
    public int getDataSize() {
        return XOMOrientation.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XOMOrientation(long addr) {
        log.finest("Creating");
        this.pData = addr;
        this.should_free_memory = false;
    }

    public XOMOrientation() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XOMOrientation.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_num_orientation() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_num_orientation(int v) {
        log.finest("");
        Native.putInt(this.pData + 0L, v);
    }

    public int get_orientation(int index) {
        log.finest("");
        return Native.getInt(Native.getLong(this.pData + 4L) + (long)(index * 4));
    }

    public long get_orientation() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_orientation(long v) {
        log.finest("");
        Native.putLong(this.pData + 4L, v);
    }

    @Override
    String getName() {
        return "XOMOrientation";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder ret = new StringBuilder(80);
        ret.append("num_orientation = ").append(this.get_num_orientation()).append(", ");
        ret.append("orientation = ").append(this.get_orientation()).append(", ");
        return ret.toString();
    }
}

