/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.misc.BASE64Encoder;
import sun.net.www.MessageHeader;

public class Manifest {
    private Vector entries = new Vector();
    private byte[] tmpbuf = new byte[512];
    private Hashtable tableEntries = new Hashtable();
    static final String[] hashes = new String[]{"SHA"};
    static final byte[] EOL = new byte[]{13, 10};
    static final boolean debug = false;
    static final String VERSION = "1.0";

    static final void debug(String s) {
    }

    public Manifest() {
    }

    public Manifest(byte[] bytes) throws IOException {
        this(new ByteArrayInputStream(bytes), false);
    }

    public Manifest(InputStream is) throws IOException {
        this(is, true);
    }

    public Manifest(InputStream is, boolean compute) throws IOException {
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        while (true) {
            is.mark(1);
            if (is.read() == -1) break;
            is.reset();
            MessageHeader m = new MessageHeader(is);
            if (compute) {
                this.doHashes(m);
            }
            this.addEntry(m);
        }
    }

    public Manifest(String[] files) throws IOException {
        MessageHeader globals = new MessageHeader();
        globals.add("Manifest-Version", VERSION);
        String jdkVersion = System.getProperty("java.version");
        globals.add("Created-By", "Manifest JDK " + jdkVersion);
        this.addEntry(globals);
        this.addFiles(null, files);
    }

    public void addEntry(MessageHeader entry) {
        this.entries.addElement(entry);
        String name = entry.findValue("Name");
        Manifest.debug("addEntry for name: " + name);
        if (name != null) {
            this.tableEntries.put(name, entry);
        }
    }

    public MessageHeader getEntry(String name) {
        return (MessageHeader)this.tableEntries.get(name);
    }

    public MessageHeader entryAt(int i) {
        return (MessageHeader)this.entries.elementAt(i);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public void addFiles(File dir, String[] files) throws IOException {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = dir == null ? new File(files[i]) : new File(dir, files[i]);
            if (file.isDirectory()) {
                this.addFiles(file, file.list());
                continue;
            }
            this.addFile(file);
        }
    }

    private final String stdToLocal(String name) {
        return name.replace('/', File.separatorChar);
    }

    private final String localToStd(String name) {
        if ((name = name.replace(File.separatorChar, '/')).startsWith("./")) {
            name = name.substring(2);
        } else if (name.startsWith("/")) {
            name = name.substring(1);
        }
        return name;
    }

    public void addFile(File f) throws IOException {
        String stdName = this.localToStd(f.getPath());
        if (this.tableEntries.get(stdName) == null) {
            MessageHeader mh = new MessageHeader();
            mh.add("Name", stdName);
            this.addEntry(mh);
        }
    }

    public void doHashes(MessageHeader mh) throws IOException {
        String name = mh.findValue("Name");
        if (name == null || name.endsWith("/")) {
            return;
        }
        BASE64Encoder enc = new BASE64Encoder();
        for (int j = 0; j < hashes.length; ++j) {
            try (FileInputStream is = new FileInputStream(this.stdToLocal(name));){
                int len;
                MessageDigest dig = MessageDigest.getInstance(hashes[j]);
                while ((len = ((InputStream)is).read(this.tmpbuf, 0, this.tmpbuf.length)) != -1) {
                    dig.update(this.tmpbuf, 0, len);
                }
                mh.set(hashes[j] + "-Digest", enc.encode(dig.digest()));
                continue;
            }
        }
    }

    public void stream(OutputStream os) throws IOException {
        PrintStream ps = os instanceof PrintStream ? (PrintStream)os : new PrintStream(os);
        MessageHeader globals = (MessageHeader)this.entries.elementAt(0);
        if (globals.findValue("Manifest-Version") == null) {
            String jdkVersion = System.getProperty("java.version");
            if (globals.findValue("Name") == null) {
                globals.prepend("Manifest-Version", VERSION);
                globals.add("Created-By", "Manifest JDK " + jdkVersion);
            } else {
                ps.print("Manifest-Version: 1.0\r\nCreated-By: " + jdkVersion + "\r\n\r\n");
            }
            ps.flush();
        }
        globals.print(ps);
        for (int i = 1; i < this.entries.size(); ++i) {
            MessageHeader mh = (MessageHeader)this.entries.elementAt(i);
            mh.print(ps);
        }
    }

    public static boolean isManifestName(String name) {
        if (name.charAt(0) == '/') {
            name = name.substring(1, name.length());
        }
        return (name = name.toUpperCase()).equals("META-INF/MANIFEST.MF");
    }
}

