<?php

/**
 * @file
 * Contains \Drupal\Core\Cache\Context\RequestStackCacheContextBase.
 */

namespace Drupal\Core\Cache\Context;

use Symfony\Component\HttpFoundation\RequestStack;

/**
 * Defines a base class for cache contexts depending only on the request stack.
 *
 * Subclasses need to implement either
 * \Drupal\Core\Cache\Context\CacheContextInterface or
 * \Drupal\Core\Cache\Context\CalculatedCacheContextInterface.
 */
abstract class RequestStackCacheContextBase {

  /**
   * The request stack.
   *
   * @var \Symfony\Component\HttpFoundation\RequestStack
   */
  protected $requestStack;

  /**
   * Constructs a new RequestStackCacheContextBase class.
   *
   * @param \Symfony\Component\HttpFoundation\RequestStack $request_stack
   *   The request stack.
   */
  public function __construct(RequestStack $request_stack) {
    $this->requestStack = $request_stack;
  }

}
