/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.options;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.tasks.options.AbstractOptionElement;
import org.gradle.api.internal.tasks.options.Option;
import org.gradle.api.internal.tasks.options.OptionNotationParserFactory;
import org.gradle.api.internal.tasks.options.OptionValidationException;
import org.gradle.internal.typeconversion.NotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldOptionElement
extends AbstractOptionElement {
    private final Field field;

    public static FieldOptionElement create(Option option, Field field, OptionNotationParserFactory optionNotationParserFactory) {
        String optionName = FieldOptionElement.calOptionName(option, field);
        Class<?> optionType = FieldOptionElement.calculateOptionType(field.getType());
        NotationParser<CharSequence, ?> notationParser = FieldOptionElement.createNotationParserOrFail(optionNotationParserFactory, optionName, optionType, field.getDeclaringClass());
        return new FieldOptionElement(field, optionName, option, optionType, notationParser);
    }

    public FieldOptionElement(Field field, String optionName, Option option, Class<?> optionType, NotationParser<CharSequence, ?> notationParser) {
        super(optionName, option, optionType, field.getDeclaringClass(), notationParser);
        this.field = field;
        this.getSetter();
    }

    private static String calOptionName(Option option, Field field) {
        if (option.option().length() == 0) {
            return field.getName();
        }
        return option.option();
    }

    private Method getSetter() {
        try {
            String setterName = "set" + StringUtils.capitalize((String)this.field.getName());
            return this.field.getDeclaringClass().getMethod(setterName, this.field.getType());
        }
        catch (NoSuchMethodException e) {
            throw new OptionValidationException(String.format("No setter for Option annotated field '%s' in class '%s'.", this.getElementName(), this.getDeclaredClass()));
        }
    }

    @Override
    public String getElementName() {
        return this.field.getName();
    }

    @Override
    public Class<?> getDeclaredClass() {
        return this.field.getDeclaringClass();
    }

    @Override
    public void apply(Object object, List<String> parameterValues) {
        if (this.getOptionType() == Void.TYPE && parameterValues.size() == 0) {
            this.setFieldValue(object, true);
        } else {
            if (parameterValues.size() > 1) {
                throw new IllegalArgumentException(String.format("Lists not supported for option", new Object[0]));
            }
            Object arg = this.getNotationParser().parseNotation(parameterValues.get(0));
            this.setFieldValue(object, arg);
        }
    }

    private void setFieldValue(Object object, Object value) {
        Method setter = this.getSetter();
        this.invokeMethod(object, setter, value);
    }
}

