/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.ext.psych;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF16BEEncoding;
import org.jcodings.specific.UTF16LEEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.RubyEncoding;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.adapaters.InputStreamAdapter;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.io.EncodingUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.parser.ParserImpl;
import org.yaml.snakeyaml.reader.ReaderException;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.ScannerException;

@CoreClass(name="Psych::Parser")
public abstract class PsychParserNodes {

    @CoreMethod(names={"parse"}, required=1, optional=1)
    public static abstract class ParseNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ToStrNode toStrNode = ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null);

        public ParseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object parse(VirtualFrame frame, DynamicObject parserObject, DynamicObject yaml, NotProvided path) {
            return this.parse(frame, parserObject, yaml, this.nil());
        }

        @Specialization
        public Object parse(VirtualFrame frame, DynamicObject parserObject, DynamicObject yaml, DynamicObject path) {
            return this.doParse(parserObject, yaml, path, this.readerFor(frame, yaml));
        }

        @CompilerDirectives.TruffleBoundary
        private Object doParse(DynamicObject parserObject, DynamicObject yaml, DynamicObject path, StreamReader streamReader) {
            boolean tainted = (Boolean)this.ruby("yaml.tainted? || yaml.is_a?(IO)", "yaml", yaml);
            ParserImpl parser = new ParserImpl(streamReader);
            try {
                Layouts.PSYCH_PARSER.setParser(parserObject, parser);
                if (this.isNil(path) && ((Boolean)this.ruby("yaml.respond_to? :path", "yaml", yaml)).booleanValue()) {
                    path = (DynamicObject)this.ruby("yaml.path", "yaml", yaml);
                }
                Object handler = this.getInstanceVariable("@handler");
                while (true) {
                    Event event = parser.getEvent();
                    Layouts.PSYCH_PARSER.setEvent(parserObject, event);
                    if (event.is(Event.ID.StreamStart)) {
                        this.invoke(handler, "start_stream", YAMLEncoding.YAML_ANY_ENCODING.ordinal());
                        continue;
                    }
                    if (event.is(Event.ID.DocumentStart)) {
                        this.handleDocumentStart((DocumentStartEvent)event, tainted, handler);
                        continue;
                    }
                    if (event.is(Event.ID.DocumentEnd)) {
                        Boolean notExplicit = !((DocumentEndEvent)event).getExplicit();
                        this.invoke(handler, "end_document", notExplicit);
                        continue;
                    }
                    if (event.is(Event.ID.Alias)) {
                        Object alias = this.stringOrNilFor(((AliasEvent)event).getAnchor(), tainted);
                        this.invoke(handler, "alias", alias);
                        continue;
                    }
                    if (event.is(Event.ID.Scalar)) {
                        this.handleScalar((ScalarEvent)event, tainted, handler);
                        continue;
                    }
                    if (event.is(Event.ID.SequenceStart)) {
                        this.handleSequenceStart((SequenceStartEvent)event, tainted, handler);
                        continue;
                    }
                    if (event.is(Event.ID.SequenceEnd)) {
                        this.invoke(handler, "end_sequence", new Object[0]);
                        continue;
                    }
                    if (event.is(Event.ID.MappingStart)) {
                        this.handleMappingStart((MappingStartEvent)event, tainted, handler);
                        continue;
                    }
                    if (event.is(Event.ID.MappingEnd)) {
                        this.invoke(handler, "end_mapping", new Object[0]);
                        continue;
                    }
                    if (event.is(Event.ID.StreamEnd)) break;
                }
                this.invoke(handler, "end_stream", new Object[0]);
            }
            catch (ParserException pe) {
                Layouts.PSYCH_PARSER.setParser(parserObject, null);
                this.raiseParserException(yaml, pe, path);
            }
            catch (ScannerException se) {
                Layouts.PSYCH_PARSER.setParser(parserObject, null);
                StringBuilder message = new StringBuilder("syntax error");
                if (se.getProblemMark() != null) {
                    message.append(se.getProblemMark().toString());
                }
                this.raiseParserException(yaml, se, path);
            }
            catch (ReaderException re) {
                Layouts.PSYCH_PARSER.setParser(parserObject, null);
                this.raiseParserException(yaml, re, path);
            }
            catch (Throwable t) {
                Helpers.throwException((Throwable)t);
                Layouts.PSYCH_PARSER.setParser(parserObject, null);
                return parserObject;
            }
            return parserObject;
        }

        private StreamReader readerFor(VirtualFrame frame, DynamicObject yaml) {
            if (!RubyGuards.isRubyString(yaml) && ((Boolean)this.ruby("yaml.respond_to? :read", "yaml", yaml)).booleanValue()) {
                UTF8Encoding enc = UTF8Encoding.INSTANCE;
                Charset charset = enc.getCharset();
                return new StreamReader(new InputStreamReader((InputStream)new InputStreamAdapter(this.getContext(), yaml), charset));
            }
            ByteList byteList = StringOperations.getByteList(this.toStrNode.coerceObject(frame, yaml));
            Encoding enc = byteList.getEncoding();
            if (!(enc instanceof UnicodeEncoding)) {
                byteList = EncodingUtils.strConvEnc((ThreadContext)this.getContext().getRuntime().getCurrentContext(), (ByteList)byteList, (Encoding)enc, (Encoding)UTF8Encoding.INSTANCE);
                enc = UTF8Encoding.INSTANCE;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            Charset charset = enc.getCharset();
            assert (charset != null) : "charset for encoding " + enc + " should not be null";
            InputStreamReader isr = new InputStreamReader((InputStream)bais, charset);
            return new StreamReader(isr);
        }

        private void handleDocumentStart(DocumentStartEvent dse, boolean tainted, Object handler) {
            DumperOptions.Version _version = dse.getVersion();
            Integer[] versionInts = _version == null ? null : _version.getArray();
            DynamicObject version = versionInts == null ? Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0) : Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), new Object[]{versionInts[0], versionInts[1]}, 2);
            Map<String, String> tagsMap = dse.getTags();
            DynamicObject tags = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
            if (tagsMap != null && tagsMap.size() > 0) {
                for (Map.Entry<String, String> tag : tagsMap.entrySet()) {
                    Object key = this.stringFor(tag.getKey(), tainted);
                    Object value = this.stringFor(tag.getValue(), tainted);
                    this.ruby("tags.push [key, value]", "tags", tags, "key", key, "value", value);
                }
            }
            Boolean notExplicit = !dse.getExplicit();
            this.invoke(handler, "start_document", version, tags, notExplicit);
        }

        private void handleMappingStart(MappingStartEvent mse, boolean tainted, Object handler) {
            Object anchor = this.stringOrNilFor(mse.getAnchor(), tainted);
            Object tag = this.stringOrNilFor(mse.getTag(), tainted);
            Boolean implicit = mse.getImplicit();
            Integer style = ParseNode.translateFlowStyle(mse.getFlowStyle());
            this.invoke(handler, "start_mapping", anchor, tag, implicit, style);
        }

        private void handleScalar(ScalarEvent se, boolean tainted, Object handler) {
            Object anchor = this.stringOrNilFor(se.getAnchor(), tainted);
            Object tag = this.stringOrNilFor(se.getTag(), tainted);
            Boolean plain_implicit = se.getImplicit().canOmitTagInPlainScalar();
            Boolean quoted_implicit = se.getImplicit().canOmitTagInNonPlainScalar();
            Integer style = ParseNode.translateStyle(se.getStyle());
            Object val = this.stringFor(se.getValue(), tainted);
            this.invoke(handler, "scalar", val, anchor, tag, plain_implicit, quoted_implicit, style);
        }

        private void handleSequenceStart(SequenceStartEvent sse, boolean tainted, Object handler) {
            Object anchor = this.stringOrNilFor(sse.getAnchor(), tainted);
            Object tag = this.stringOrNilFor(sse.getTag(), tainted);
            Boolean implicit = sse.getImplicit();
            Integer style = ParseNode.translateFlowStyle(sse.getFlowStyle());
            this.invoke(handler, "start_sequence", anchor, tag, implicit, style);
        }

        private void raiseParserException(DynamicObject yaml, ReaderException re, DynamicObject rbPath) {
            this.ruby("raise Psych::SyntaxError.new(file, line, col, offset, problem, context)", "file", rbPath, "line", 0, "col", 0, "offset", re.getPosition(), "problem", re.getName() == null ? this.nil() : this.createString(new ByteList(re.getName().getBytes(StandardCharsets.UTF_8))), "context", re.toString() == null ? this.nil() : this.createString(new ByteList(re.toString().getBytes(StandardCharsets.UTF_8))));
        }

        private void raiseParserException(DynamicObject yaml, MarkedYAMLException mye, DynamicObject rbPath) {
            Mark mark = mye.getProblemMark();
            this.ruby("raise Psych::SyntaxError.new(file, line, col, offset, problem, context)", "file", rbPath, "line", mark.getLine(), "col", mark.getColumn(), "offset", mark.getIndex(), "problem", mye.getProblem() == null ? this.nil() : this.createString(new ByteList(mye.getProblem().getBytes(StandardCharsets.UTF_8))), "context", mye.getContext() == null ? this.nil() : this.createString(new ByteList(mye.getContext().getBytes(StandardCharsets.UTF_8))));
        }

        private Object invoke(Object receiver, String name, Object ... args) {
            return this.ruby("receiver.send(name, *args)", "receiver", receiver, "name", this.getSymbol(name), "args", Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), args, args.length));
        }

        private static int translateStyle(Character style) {
            if (style == null) {
                return 0;
            }
            switch (style.charValue()) {
                case '\u0000': {
                    return 1;
                }
                case '\'': {
                    return 2;
                }
                case '\"': {
                    return 3;
                }
                case '|': {
                    return 4;
                }
                case '>': {
                    return 5;
                }
            }
            return 0;
        }

        private static int translateFlowStyle(Boolean flowStyle) {
            if (flowStyle == null) {
                return 0;
            }
            if (flowStyle.booleanValue()) {
                return 2;
            }
            return 1;
        }

        private Object stringOrNilFor(String value, boolean tainted) {
            if (value == null) {
                return this.nil();
            }
            return this.stringFor(value, tainted);
        }

        private Object stringFor(String value, boolean tainted) {
            Encoding encoding = this.getContext().getRuntime().getDefaultInternalEncoding();
            if (encoding == null) {
                encoding = UTF8Encoding.INSTANCE;
            }
            Charset charset = RubyEncoding.UTF8;
            if (encoding.getCharset() != null) {
                charset = encoding.getCharset();
            }
            ByteList bytes = new ByteList(value.getBytes(charset), encoding);
            DynamicObject string = this.createString(bytes);
            if (tainted) {
                this.ruby("string.taint", "string", string);
            }
            return string;
        }

        private Object getInstanceVariable(String name) {
            return this.ruby(name, new Object[0]);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private AllocateObjectNode allocateNode;

        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return this.allocateNode.allocate(rubyClass, null, null);
        }
    }

    public static enum YAMLEncoding {
        YAML_ANY_ENCODING((Encoding)UTF8Encoding.INSTANCE),
        YAML_UTF8_ENCODING((Encoding)UTF8Encoding.INSTANCE),
        YAML_UTF16LE_ENCODING((Encoding)UTF16LEEncoding.INSTANCE),
        YAML_UTF16BE_ENCODING((Encoding)UTF16BEEncoding.INSTANCE);

        public final Encoding encoding;

        private YAMLEncoding(Encoding encoding) {
            this.encoding = encoding;
        }
    }
}

