/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCookies;
import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarEntry;
import edu.umass.cs.benchlab.har.HarHeaders;
import edu.umass.cs.benchlab.har.HarPostData;
import edu.umass.cs.benchlab.har.HarQueryString;
import edu.umass.cs.benchlab.har.HarWarning;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarRequest {
    public static String TABLE_NAME = "request";
    private String method;
    private String url;
    private String httpVersion;
    private HarCookies cookies;
    private HarHeaders headers;
    private HarQueryString queryString;
    private HarPostData postData;
    private Long headersSize;
    private Long bodySize;
    private String comment;
    private HarCustomFields customFields = new HarCustomFields();

    public HarRequest(String method, String url, String httpVersion, HarCookies cookies, HarHeaders headers, HarQueryString queryString, HarPostData postData, long headersSize, long bodySize, String comment) {
        this.method = method;
        this.url = url;
        this.httpVersion = httpVersion;
        this.cookies = cookies;
        this.headers = headers;
        this.queryString = queryString;
        this.postData = postData;
        this.headersSize = headersSize;
        this.bodySize = bodySize;
        this.comment = comment;
    }

    public HarRequest(String method, String url, String httpVersion, HarCookies cookies, HarHeaders headers, HarQueryString queryString, long headersSize, long bodySize) {
        this.method = method;
        this.url = url;
        this.httpVersion = httpVersion;
        this.cookies = cookies;
        this.headers = headers;
        this.queryString = queryString;
        this.headersSize = headersSize;
        this.bodySize = bodySize;
    }

    public HarRequest(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"request\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("method".equals(name)) {
                this.setMethod(jp.getText());
                continue;
            }
            if ("url".equals(name)) {
                this.setUrl(jp.getText());
                continue;
            }
            if ("httpVersion".equals(name)) {
                this.setHttpVersion(jp.getText());
                continue;
            }
            if ("cookies".equals(name)) {
                this.setCookies(new HarCookies(jp, warnings));
                continue;
            }
            if ("headers".equals(name)) {
                this.setHeaders(new HarHeaders(jp, warnings));
                continue;
            }
            if ("queryString".equals(name)) {
                this.setQueryString(new HarQueryString(jp, warnings));
                continue;
            }
            if ("postData".equals(name)) {
                this.setPostData(new HarPostData(jp, warnings));
                continue;
            }
            if ("headersSize".equals(name)) {
                this.setHeadersSize(jp.getValueAsLong());
                continue;
            }
            if ("bodySize".equals(name)) {
                this.setBodySize(jp.getValueAsLong());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in request element", jp.getCurrentLocation());
        }
        if (this.method == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing name field in request element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing name field in request element", jp.getCurrentLocation());
            }
        }
        if (this.url == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing url field in request element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing url field in request element", jp.getCurrentLocation());
            }
        }
        if (this.httpVersion == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing httpVersion field in request element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing httpVersion field in request element", jp.getCurrentLocation());
            }
        }
        if (this.cookies == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing cookies field in request element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing cookies field in request element", jp.getCurrentLocation());
            }
        }
        if (this.headers == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing headers field in request element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing headers field in request element", jp.getCurrentLocation());
            }
        }
        if (this.queryString == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing queryString field in request element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing queryString field in request element", jp.getCurrentLocation());
            }
        }
        if (this.headersSize == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing headersSize field in request element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing headersSize field in request element", jp.getCurrentLocation());
            }
        }
        if (this.bodySize == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing bodySize field in request element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing bodySize field in request element", jp.getCurrentLocation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HarRequest(HarDatabaseConfig config, long entryId) throws SQLException {
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("SELECT id,method,url,http_version,header_size,body_size,comment FROM " + tableName + " WHERE entry_id=?");
            ps.setLong(1, entryId);
            rs = ps.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No HarRequest for entry id " + entryId + " found in database");
            }
            long requestId = rs.getLong(1);
            this.setMethod(rs.getString(2));
            this.setUrl(rs.getString(3));
            this.setHttpVersion(rs.getString(4));
            this.setHeadersSize(rs.getLong(5));
            this.setBodySize(rs.getLong(6));
            this.setComment(rs.getString(7));
            this.cookies = new HarCookies(config, requestId, true);
            this.headers = new HarHeaders(config, requestId, true);
            this.queryString = new HarQueryString(config, requestId);
            try {
                this.postData = new HarPostData(config, requestId);
            }
            catch (SQLException ignore) {
                this.postData = null;
            }
            this.customFields.readCustomFieldsJDBC(config, HarCustomFields.Type.HARREQUEST, requestId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeObjectFieldStart("request");
        g.writeStringField("method", this.method);
        g.writeStringField("url", this.url);
        g.writeStringField("httpVersion", this.httpVersion);
        this.cookies.writeHar(g);
        this.headers.writeHar(g);
        this.queryString.writeHar(g);
        if (this.postData != null) {
            this.postData.writeHar(g);
        }
        g.writeNumberField("headersSize", this.headersSize);
        g.writeNumberField("bodySize", this.bodySize);
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJDBC(long entryId, HarDatabaseConfig config, long logId) throws SQLException {
        long requestId;
        Connection c = config.getConnection();
        String tableName = config.getTablePrefix() + TABLE_NAME;
        if (!config.isCreatedTable(tableName)) {
            try {
                Statement s = c.createStatement();
                s.executeUpdate("CREATE TABLE " + tableName + " (id " + config.getDbAutoGeneratedId() + ",method " + config.getStringDbType() + ",url " + config.getStringDbType() + ",http_version " + config.getStringDbType() + ",header_size " + config.getLongDbType() + ",body_size " + config.getLongDbType() + ",comment " + config.getStringDbType() + ",entry_id " + config.getLongDbType() + ")");
                s.close();
                config.addCreatedTable(tableName);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        Statement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement("INSERT INTO " + tableName + " (method,url,http_version,header_size,body_size,comment,entry_id) VALUES (?,?,?,?,?,?,?)", 1);
            ps.setString(1, this.method);
            ps.setString(2, this.url);
            ps.setString(3, this.httpVersion);
            ps.setLong(4, this.headersSize);
            ps.setLong(5, this.bodySize);
            if (this.comment == null) {
                ps.setNull(6, -1);
            } else {
                ps.setString(6, this.comment);
            }
            ps.setLong(7, entryId);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            if (!rs.next()) {
                throw new SQLException("The database did not generate a key for an HarRequest entry");
            }
            requestId = rs.getLong(1);
            this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARREQUEST, requestId, logId);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception ignore) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Exception ignore) {}
            config.closeConnection(c);
        }
        this.cookies.writeJDBC(requestId, config, true, logId);
        this.headers.writeJDBC(requestId, config, true, logId);
        this.queryString.writeJDBC(requestId, config, logId);
        if (this.postData != null) {
            this.postData.writeJDBC(requestId, config, logId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromJDBC(HarDatabaseConfig config, long logId, boolean dropTables) throws SQLException {
        this.cookies.deleteFromJDBC(config, logId, true);
        this.headers.deleteFromJDBC(config, logId, true);
        this.queryString.deleteFromJDBC(config, logId);
        if (this.postData != null) {
            this.postData.deleteFromJDBC(config, logId);
        }
        if (dropTables) {
            Connection c = config.getConnection();
            String entriesTableName = config.getTablePrefix() + HarEntry.TABLE_NAME;
            String requestTableName = config.getTablePrefix() + TABLE_NAME;
            Statement ps = null;
            try {
                ps = c.prepareStatement("DELETE FROM " + requestTableName + " WHERE entry_id IN (SELECT entry_id FROM " + entriesTableName + " WHERE log_id=?)");
                ps.setLong(1, logId);
                ps.executeUpdate();
                config.dropTableIfEmpty(c, requestTableName, config);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (Exception ignore) {}
                config.closeConnection(c);
            }
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public HarCookies getCookies() {
        return this.cookies;
    }

    public void setCookies(HarCookies cookies) {
        this.cookies = cookies;
    }

    public HarHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HarHeaders headers) {
        this.headers = headers;
    }

    public HarQueryString getQueryString() {
        return this.queryString;
    }

    public void setQueryString(HarQueryString queryString) {
        this.queryString = queryString;
    }

    public HarPostData getPostData() {
        return this.postData;
    }

    public void setPostData(HarPostData postData) {
        this.postData = postData;
    }

    public long getHeadersSize() {
        return this.headersSize;
    }

    public void setHeadersSize(long headersSize) {
        this.headersSize = headersSize;
    }

    public long getBodySize() {
        return this.bodySize;
    }

    public void setBodySize(long bodySize) {
        this.bodySize = bodySize;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "\"request\": { \"method\": \"" + this.method + "\", \"url\": \"" + this.url + "\", \"httpVersion\": \"" + this.httpVersion + "\", " + this.cookies + ", " + this.headers + ", " + this.queryString + ", " + this.postData + ",  \"headersSize\": " + this.headersSize + ",  \"bodySize\": " + this.bodySize + ",  \"comment\": \"" + this.comment + "\", " + this.customFields + "}\n";
    }
}

