/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.embed.AbstractEvents;
import com.sun.javafx.embed.EmbeddedStageInterface;
import com.sun.javafx.embed.HostInterface;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStageListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.EmbeddedScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.prism.impl.PrismSettings;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import javafx.application.Platform;

public class EmbeddedStage
extends GlassStage
implements EmbeddedStageInterface {
    private HostInterface host;
    private boolean visible = false;

    public EmbeddedStage(HostInterface hostInterface) {
        super(PrismSettings.verbose);
        this.host = hostInterface;
    }

    @Override
    public TKScene createTKScene(boolean bl) {
        return new EmbeddedScene(this.host, bl);
    }

    @Override
    public void setScene(TKScene tKScene) {
        if (tKScene != null) assert (tKScene instanceof EmbeddedScene);
        super.setScene(tKScene);
    }

    @Override
    public void setTKStageListener(TKStageListener tKStageListener) {
        this.stageListener = tKStageListener;
    }

    @Override
    public void setBounds(float f, float f2, boolean bl, boolean bl2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        if (this.verbose) {
            System.err.println("EmbeddedStage.setBounds: x=" + f + " y=" + f2 + " xSet=" + bl + " ySet=" + bl2 + " w=" + f3 + " h=" + " cw=" + f5 + " ch=" + f6);
        }
        float f10 = f3 > 0.0f ? f3 : f5;
        float f11 = f9 = f4 > 0.0f ? f4 : f6;
        if (f10 > 0.0f && f9 > 0.0f) {
            this.host.setPreferredSize((int)f10, (int)f9);
        }
    }

    @Override
    public void setMinimumSize(int n, int n2) {
    }

    @Override
    public void setMaximumSize(int n, int n2) {
    }

    @Override
    protected void setPlatformEnabled(boolean bl) {
        this.host.setEnabled(bl);
    }

    @Override
    protected void requestToFront() {
    }

    @Override
    public void setIcons(List list) {
        if (this.verbose) {
            System.err.println("EmbeddedStage.setIcons");
        }
    }

    @Override
    public void setTitle(String string) {
        if (this.verbose) {
            System.err.println("EmbeddedStage.setTitle " + string);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
        this.host.setEmbeddedStage(bl ? this : null);
        super.setVisible(bl);
    }

    @Override
    public void setOpacity(float f) {
    }

    @Override
    public void setIconified(boolean bl) {
        if (this.verbose) {
            System.err.println("EmbeddedScene.setIconified " + bl);
        }
    }

    @Override
    public void setResizable(boolean bl) {
        if (this.verbose) {
            System.err.println("EmbeddedStage.setResizable " + bl);
        }
    }

    @Override
    public void setFullScreen(boolean bl) {
        if (this.verbose) {
            System.err.println("EmbeddedStage.setFullScreen " + bl);
        }
    }

    @Override
    public void requestFocus() {
        if (!this.host.requestFocus()) {
            return;
        }
        super.requestFocus();
    }

    @Override
    public void toBack() {
        if (this.verbose) {
            System.err.println("EmbeddedStage.toBack");
        }
    }

    @Override
    public void toFront() {
        if (this.verbose) {
            System.err.println("EmbeddedStage.toFront");
        }
    }

    @Override
    public boolean grabFocus() {
        return false;
    }

    @Override
    public void ungrabFocus() {
    }

    private void notifyStageListener(final Runnable runnable) {
        AccessControlContext accessControlContext = this.getAccessControlContext();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                runnable.run();
                return null;
            }
        }, accessControlContext);
    }

    private void notifyStageListenerLater(final Runnable runnable) {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                EmbeddedStage.this.notifyStageListener(runnable);
            }
        });
    }

    @Override
    public void setLocation(final int n, final int n2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (EmbeddedStage.this.stageListener != null) {
                    EmbeddedStage.this.stageListener.changedLocation(n, n2);
                }
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(runnable);
        } else {
            this.notifyStageListenerLater(runnable);
        }
    }

    @Override
    public void setSize(final int n, final int n2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (EmbeddedStage.this.stageListener != null) {
                    EmbeddedStage.this.stageListener.changedSize(n, n2);
                }
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(runnable);
        } else {
            this.notifyStageListenerLater(runnable);
        }
    }

    @Override
    public void setFocused(final boolean bl, final int n) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (EmbeddedStage.this.stageListener != null) {
                    EmbeddedStage.this.stageListener.changedFocused(bl, AbstractEvents.focusCauseToPeerFocusCause(n));
                }
            }
        };
        if (Toolkit.getToolkit().isFxUserThread()) {
            this.notifyStageListener(runnable);
        } else {
            this.notifyStageListenerLater(runnable);
        }
    }
}

