/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw;

import com.baselet.control.StringStyle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.AlignVertical;
import com.baselet.control.enums.FormatLabels;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.Style;
import com.baselet.util.LRUCache;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextSplitter {
    private static final int WORD_CACHE_SIZE = 180;
    private static final int MIN_WIDTH_CACHE_SIZE = 190;
    private static final int WORDWRAP_CACHE_SIZE = 400;
    private static final String SPLIT_CHARS = " \t";
    private static LinkedHashMap<String, WordRegion[]> wordCache = new LRUCache<String, WordRegion[]>(180);
    private static LinkedHashMap<MinWidthCacheKey, Double> minWidthCache = new LRUCache<MinWidthCacheKey, Double>(190);
    private static LinkedHashMap<WordwrapCacheKey, WordwrapCacheValue> wordwrapCache = new LRUCache<WordwrapCacheKey, WordwrapCacheValue>(400);
    private static final Logger log = LoggerFactory.getLogger(TextSplitter.class);

    public static void drawText(DrawHandler drawer, String[] textLines, double topLeftX, double topLeftY, double width, double height, AlignHorizontal hAlignment, AlignVertical vAlignment) {
        double textHeight = TextSplitter.getSplitStringHeight(textLines, width, drawer);
        if (textHeight > height) {
            throw new IllegalArgumentException("The text needs more height then specified in the parameter");
        }
        switch (vAlignment) {
            case TOP: {
                break;
            }
            case CENTER: {
                topLeftY += (height - textHeight) / 2.0;
                break;
            }
            case BOTTOM: {
                topLeftY += height - textHeight;
                break;
            }
            default: {
                log.error("Encountered unhandled enumeration value '" + (Object)((Object)vAlignment) + "'.");
            }
        }
        topLeftY += drawer.textHeightMax();
        switch (hAlignment) {
            case LEFT: {
                break;
            }
            case CENTER: {
                topLeftX += width / 2.0;
                break;
            }
            case RIGHT: {
                topLeftX += width;
                break;
            }
            default: {
                log.error("Encountered unhandled enumeration value '" + (Object)((Object)hAlignment) + "'.");
            }
        }
        for (String l : textLines) {
            for (StringStyle wl : TextSplitter.splitStringAlgorithm(l, width, drawer)) {
                drawer.print(wl, topLeftX, topLeftY, hAlignment);
                topLeftY += drawer.textHeightMaxWithSpace();
            }
        }
    }

    public static boolean checkifStringFitsNoWordwrap(String text, double width, DrawHandler drawer) {
        StringStyle analyzedText = StringStyle.analyzeFormatLabels(StringStyle.replaceNotEscaped(text));
        WordRegion[] words = TextSplitter.getCachedWords(analyzedText.getStringWithoutMarkup());
        if (words == null) {
            return drawer.textWidth(analyzedText.getStringWithoutMarkup()) + TextSplitter.endBuffer(drawer) + 0.01 < width;
        }
        WordwrapCacheValue wwValue = TextSplitter.getCachedWordwrap(words, width, drawer.getStyleClone(), analyzedText.getFormat());
        if (wwValue == null) {
            return drawer.textWidth(analyzedText.getStringWithoutMarkup()) + TextSplitter.endBuffer(drawer) + 0.01 < width;
        }
        return wwValue.getWrappedLines().length < 2;
    }

    public static boolean checkifStringFitsWithWordwrap(String text, double width, DrawHandler drawer) {
        return TextSplitter.getTextMinWidth(text, drawer) < width;
    }

    public static double getSplitStringHeight(String text, double width, DrawHandler drawer) {
        return TextSplitter.splitStringAndHeightAlgorithm(text, width, drawer, false).getHeight();
    }

    public static double getSplitStringHeight(String[] textLines, double width, DrawHandler drawer) {
        double height = 0.0;
        for (String l : textLines) {
            height += TextSplitter.getSplitStringHeight(l, width, drawer);
        }
        return height;
    }

    public static StringStyle[] splitStringAlgorithm(String text, double width, DrawHandler drawer) {
        return TextSplitter.splitStringAlgorithm(text, width, drawer, false);
    }

    public static StringStyle[] splitStringAlgorithm(String text, double width, DrawHandler drawer, boolean runtimeException) {
        return TextSplitter.splitStringAndHeightAlgorithm(text, width, drawer, runtimeException).getWrappedLines();
    }

    private static WordwrapCacheValue splitStringAndHeightAlgorithm(String text, double width, DrawHandler drawer, boolean runtimeException) {
        StringStyle analyzedText = StringStyle.analyzeFormatLabels(StringStyle.replaceNotEscaped(text));
        String finalText = analyzedText.getStringWithoutMarkup();
        WordRegion[] words = TextSplitter.splitIntoWords(finalText);
        WordwrapCacheKey key = new WordwrapCacheKey(words, width, drawer.getStyleClone(), analyzedText.getFormat());
        if (TextSplitter.getCachedWordwrap(key) != null) {
            return TextSplitter.getCachedWordwrap(key);
        }
        LinkedList<StringStyle> wrappedText = new LinkedList<StringStyle>();
        if (words.length > 0) {
            if ((width -= TextSplitter.endBuffer(drawer)) <= 0.0) {
                throw new IllegalArgumentException("The width needs to be bigger then the size of a 'n' character.");
            }
            int lineStart = 0;
            for (int i = 0; i < words.length; ++i) {
                if (!(drawer.textWidth(finalText.substring(words[lineStart].getBegin(), words[i].getEnd())) > width)) continue;
                if (lineStart == i) {
                    if (runtimeException) {
                        throw new RuntimeException("At least one word is to big for the specified width!");
                    }
                    int endIndex = words[lineStart].getEnd() - 1;
                    while (drawer.textWidth(finalText.substring(words[lineStart].getBegin(), endIndex)) > width) {
                        --endIndex;
                    }
                    wrappedText.add(new StringStyle(analyzedText.getFormat(), finalText.substring(words[lineStart].getBegin(), endIndex)));
                    lineStart = i;
                    continue;
                }
                wrappedText.add(new StringStyle(analyzedText.getFormat(), finalText.substring(words[lineStart].getBegin(), words[i - 1].getEnd())));
                lineStart = i;
            }
            wrappedText.add(new StringStyle(analyzedText.getFormat(), finalText.substring(words[lineStart].getBegin(), words[words.length - 1].getEnd())));
        } else {
            wrappedText.add(new StringStyle(Collections.<FormatLabels>emptySet(), ""));
        }
        double height = (double)wrappedText.size() * drawer.textHeightMaxWithSpace();
        WordwrapCacheValue wordwrapValue = new WordwrapCacheValue(wrappedText.toArray(new StringStyle[0]), height);
        TextSplitter.setCachedWordwrap(key, wordwrapValue);
        return wordwrapValue;
    }

    public static double getTextMinWidth(String text, DrawHandler drawer) {
        StringStyle analyzedText = StringStyle.analyzeFormatLabels(StringStyle.replaceNotEscaped(text));
        MinWidthCacheKey key = new MinWidthCacheKey(TextSplitter.splitIntoWords(analyzedText.getStringWithoutMarkup()), drawer.getStyleClone(), analyzedText.getFormat());
        if (TextSplitter.getCachedMinWidth(key) != null) {
            return TextSplitter.getCachedMinWidth(key);
        }
        double minWidth = 0.0;
        if (analyzedText.getStringWithoutMarkup().trim().length() > 0) {
            for (WordRegion wr : key.getWords()) {
                minWidth = Math.max(minWidth, drawer.textWidth(analyzedText.getStringWithoutMarkup().substring(wr.getBegin(), wr.getEnd())));
            }
        }
        TextSplitter.setCachedMinWidth(key, minWidth += TextSplitter.endBuffer(drawer) + 0.01);
        return minWidth;
    }

    public static double getTextMinWidth(String[] textLines, DrawHandler drawer) {
        double minWidth = 0.0;
        for (String line : textLines) {
            minWidth = Math.max(minWidth, TextSplitter.getTextMinWidth(line, drawer));
        }
        return minWidth;
    }

    private static WordRegion[] splitIntoWords(String text) {
        WordRegion[] words = TextSplitter.getCachedWords(text);
        if (words == null) {
            words = new WordRegion[]{};
            if (text.trim().length() > 0) {
                int wordStart = 0;
                int current = 0;
                while (TextSplitter.isWhitespace(text.charAt(current))) {
                    ++current;
                }
                ++current;
                boolean inWord = true;
                while (current < text.length()) {
                    if (inWord) {
                        if (TextSplitter.isWhitespace(text.charAt(current))) {
                            words = Arrays.copyOf(words, words.length + 1);
                            words[words.length - 1] = new WordRegion(wordStart, current);
                            inWord = false;
                        }
                    } else if (!TextSplitter.isWhitespace(text.charAt(current))) {
                        wordStart = current;
                        inWord = true;
                    }
                    ++current;
                }
                if (inWord) {
                    words = Arrays.copyOf(words, words.length + 1);
                    words[words.length - 1] = new WordRegion(wordStart, current);
                }
            }
            TextSplitter.setCachedWords(text, words);
        }
        return words;
    }

    private static boolean isWhitespace(char c) {
        for (int i = 0; i < SPLIT_CHARS.length(); ++i) {
            if (SPLIT_CHARS.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    private static double endBuffer(DrawHandler drawer) {
        return drawer.textWidth("n");
    }

    private static WordRegion[] getCachedWords(String lineKey) {
        return wordCache.get(lineKey);
    }

    private static void setCachedWords(String lineKey, WordRegion[] words) {
        wordCache.put(lineKey, words);
    }

    private static Double getCachedMinWidth(MinWidthCacheKey key) {
        return minWidthCache.get(key);
    }

    private static Double getCachedMinWidth(WordRegion[] words, Style style, Set<FormatLabels> format) {
        return TextSplitter.getCachedMinWidth(new MinWidthCacheKey(words, style, format));
    }

    private static void setCachedMinWidth(MinWidthCacheKey key, Double value) {
        minWidthCache.put(key, value);
    }

    private static WordwrapCacheValue getCachedWordwrap(WordwrapCacheKey key) {
        return wordwrapCache.get(key);
    }

    private static WordwrapCacheValue getCachedWordwrap(WordRegion[] words, double width, Style style, Set<FormatLabels> format) {
        return TextSplitter.getCachedWordwrap(new WordwrapCacheKey(words, width, style, format));
    }

    private static void setCachedWordwrap(WordwrapCacheKey key, WordwrapCacheValue value) {
        wordwrapCache.put(key, value);
    }

    private static void setCachedWordwrap(WordwrapCacheKey key, StringStyle[] wrappedLines, double height) {
        wordwrapCache.put(key, new WordwrapCacheValue(wrappedLines, height));
    }

    private static void setCachedWordwrap(WordRegion[] words, double width, Style style, Set<FormatLabels> format, StringStyle[] wrappedLines, double height) {
        wordwrapCache.put(new WordwrapCacheKey(words, width, style, format), new WordwrapCacheValue(wrappedLines, height));
    }

    private static void setCachedWordwrap(WordwrapCacheKey key, String[] wrappedLines, double height) {
        wordwrapCache.put(key, new WordwrapCacheValue(wrappedLines, key.format, height));
    }

    private static void setCachedWordwrap(WordRegion[] words, double width, Style style, Set<FormatLabels> format, String[] wrappedLines, double height) {
        wordwrapCache.put(new WordwrapCacheKey(words, width, style, format), new WordwrapCacheValue(wrappedLines, format, height));
    }

    private static class WordwrapCacheValue {
        private final StringStyle[] wrappedLines;
        private final double height;

        public WordwrapCacheValue(StringStyle[] wrappedLines, double height) {
            this.wrappedLines = wrappedLines;
            this.height = height;
        }

        public WordwrapCacheValue(String[] wrappedLines, Set<FormatLabels> format, double height) {
            this.wrappedLines = new StringStyle[wrappedLines.length];
            for (int i = 0; i < wrappedLines.length; ++i) {
                this.wrappedLines[i] = new StringStyle(format, wrappedLines[i]);
            }
            this.height = height;
        }

        public StringStyle[] getWrappedLines() {
            return this.wrappedLines;
        }

        public double getHeight() {
            return this.height;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            long temp = Double.doubleToLongBits(this.height);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + Arrays.hashCode(this.wrappedLines);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WordwrapCacheValue other = (WordwrapCacheValue)obj;
            if (Double.doubleToLongBits(this.height) != Double.doubleToLongBits(other.height)) {
                return false;
            }
            return Arrays.equals(this.wrappedLines, other.wrappedLines);
        }
    }

    private static class WordwrapCacheKey {
        private final WordRegion[] words;
        private final double width;
        private final Style style;
        private final Set<FormatLabels> format;

        public WordwrapCacheKey(WordRegion[] words, double width, Style style, Set<FormatLabels> format) {
            this.words = words;
            this.width = width;
            this.style = style;
            this.format = format;
        }

        public WordRegion[] getWords() {
            return this.words;
        }

        public double getWidth() {
            return this.width;
        }

        public Style getStyle() {
            return this.style;
        }

        public Set<FormatLabels> getFormat() {
            return this.format;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.words == null ? 0 : this.words.hashCode());
            result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
            long temp = Double.doubleToLongBits(this.width);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            for (FormatLabels fl : this.format) {
                result = 31 * result + fl.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WordwrapCacheKey other = (WordwrapCacheKey)obj;
            if (this.words == null ? other.words != null : !this.words.equals(other.words)) {
                return false;
            }
            if (this.style == null ? other.style != null : !this.style.equals(other.style)) {
                return false;
            }
            if (Double.doubleToLongBits(this.width) != Double.doubleToLongBits(other.width)) {
                return false;
            }
            if (this.format == null) {
                if (other.format != null) {
                    return false;
                }
            } else {
                if (this.format.size() != other.format.size()) {
                    return false;
                }
                if (!this.format.containsAll(other.format)) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class MinWidthCacheKey {
        private final WordRegion[] words;
        private final Style style;
        private final Set<FormatLabels> format;

        public MinWidthCacheKey(WordRegion[] words, Style style, Set<FormatLabels> format) {
            this.words = words;
            this.style = style;
            this.format = format;
        }

        public WordRegion[] getWords() {
            return this.words;
        }

        public Style getStyle() {
            return this.style;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.words == null ? 0 : this.words.hashCode());
            result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
            for (FormatLabels fl : this.format) {
                result = 31 * result + fl.hashCode();
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MinWidthCacheKey other = (MinWidthCacheKey)obj;
            if (this.words == null ? other.words != null : !this.words.equals(other.words)) {
                return false;
            }
            if (this.style == null ? other.style != null : !this.style.equals(other.style)) {
                return false;
            }
            if (this.format == null) {
                if (other.format != null) {
                    return false;
                }
            } else {
                if (this.format.size() != other.format.size()) {
                    return false;
                }
                if (!this.format.containsAll(other.format)) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class WordRegion {
        private final int begin;
        private final int end;

        public WordRegion(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public int getBegin() {
            return this.begin;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

