/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.parser;

import com.baselet.element.elementnew.plot.parser.DataSet;
import com.baselet.element.elementnew.plot.parser.KeyValue;
import com.baselet.element.elementnew.plot.parser.ParserException;
import com.baselet.element.elementnew.plot.parser.ParserResult;
import com.baselet.element.elementnew.plot.parser.PlotState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    private static final Logger log = LoggerFactory.getLogger(Parser.class);
    private final ParserResult parserResult = new ParserResult();
    private final HashMap<String, KeyValue> tempPlotValuesCache;
    private int datasetNr = 1;
    private final ArrayList<DataSet> datasetList = new ArrayList();

    public Parser() {
        this.tempPlotValuesCache = new HashMap();
    }

    public ParserResult parse(String source) {
        List<String> inputList = Arrays.asList(source.split("\n", -1));
        ListIterator<String> inputIterator = inputList.listIterator();
        while (inputIterator.hasNext()) {
            String line = inputIterator.next();
            if (line.isEmpty() || line.matches("(//.*)")) continue;
            if (line.matches("((plot ?)|(plot ((([(\\w)\\.]+)=([-(\\w)#\\.,]*)) )*(([(\\w)\\.]+)=([-(\\w)#\\.,]*))))")) {
                this.parserResult.addPlotState(this.createPlotStateObject(line.split(" "), inputIterator));
                continue;
            }
            if (line.matches("(\\+((plot ?)|(plot ((([(\\w)\\.]+)=([-(\\w)#\\.,]*)) )*(([(\\w)\\.]+)=([-(\\w)#\\.,]*)))))")) {
                ArrayList<PlotState> plotStates = this.parserResult.getPlotStateList();
                if (plotStates.isEmpty()) {
                    this.parserResult.addPlotState(this.createPlotStateObject(line.split(" "), inputIterator));
                    continue;
                }
                PlotState last = (PlotState)plotStates.get(plotStates.size() - 1);
                last.addSubPlot(this.createPlotStateObject(line.split(" "), inputIterator));
                continue;
            }
            if (line.matches("((data ?)|(data (\\w)+))")) {
                this.createDatasetObject(line.split(" "), inputIterator);
                continue;
            }
            if (line.matches("((?!((//.*)))(([^=]+)|(.*([\t ]+).*)))")) {
                inputIterator.previous();
                this.createDatasetObject(new String[]{"data"}, inputIterator);
                continue;
            }
            if (line.matches("(([(\\w)\\.]+)=([-(\\w)#\\.,]*))")) {
                this.createKeyValueAssignment(line, inputIterator.nextIndex());
                continue;
            }
            throw new ParserException("Invalid line: " + line + "(line: " + inputIterator.nextIndex() + ")");
        }
        this.analyseDatasets();
        this.addDatasetsToPlotStates();
        return this.parserResult;
    }

    private void analyseDatasets() {
        for (DataSet dataset : this.datasetList) {
            dataset.analyseMatrix();
        }
    }

    private void addDatasetsToPlotStates() {
        if (this.datasetList.isEmpty()) {
            throw new ParserException("You must specify at least one dataset.");
        }
        int actualAutoDatasetNr = 0;
        for (PlotState plotState : this.parserResult.getPlotStateList()) {
            actualAutoDatasetNr = this.addDataset(plotState, actualAutoDatasetNr);
            for (PlotState subPlotState : plotState.getSubplots()) {
                log.info("Add dataset for subplot");
                actualAutoDatasetNr = this.addDataset(subPlotState, actualAutoDatasetNr);
            }
        }
    }

    private int addDataset(PlotState plotState, int actualAutoDatasetNr) {
        String datasetId = plotState.getValue("data", null);
        if (datasetId == null) {
            if (actualAutoDatasetNr >= this.datasetList.size()) {
                actualAutoDatasetNr = 0;
            }
            plotState.setDataSet(this.datasetList.get(actualAutoDatasetNr++));
        } else {
            DataSet dataset = null;
            if (datasetId.startsWith("#")) {
                String datasetNr = datasetId.substring(1);
                for (DataSet tempDataset : this.datasetList) {
                    if (!datasetNr.equals(String.valueOf(tempDataset.getNr()))) continue;
                    dataset = tempDataset;
                }
            } else {
                for (DataSet tempDataset : this.datasetList) {
                    if (!datasetId.equals(tempDataset.getId())) continue;
                    dataset = tempDataset;
                }
            }
            if (dataset != null) {
                plotState.setDataSet(dataset);
            } else {
                throw new ParserException("data", datasetId, plotState.getLine("data"));
            }
        }
        return actualAutoDatasetNr;
    }

    private void createDatasetObject(String[] args, ListIterator<String> inputIterator) {
        int lineNr = inputIterator.nextIndex();
        String datasetId = null;
        if (args != null && args.length > 1) {
            datasetId = args[1];
        }
        DataSet newDataset = new DataSet(datasetId, this.datasetNr++, lineNr);
        while (inputIterator.hasNext()) {
            String nextLine = inputIterator.next();
            if (nextLine.matches("(//.*)")) continue;
            if (nextLine.trim().isEmpty()) break;
            newDataset.addLine(nextLine.split("([\t ]+)"));
        }
        if (datasetId != null) {
            for (DataSet ds : this.datasetList) {
                if (!datasetId.equals(ds.getId())) continue;
                throw new ParserException("The dataset name \"" + datasetId + "\" (line: " + lineNr + ") already exists");
            }
        }
        this.datasetList.add(newDataset);
    }

    private PlotState createPlotStateObject(String[] args, ListIterator<String> inputIterator) {
        int lineNr = inputIterator.nextIndex();
        HashMap<String, KeyValue> localCopyOfValuesCache = this.copyHashMap(this.tempPlotValuesCache);
        if (args != null) {
            for (int i = 1; i < args.length; ++i) {
                String[] split = args[i].split("=");
                if (split.length == 1) {
                    split = new String[]{split[0], ""};
                }
                localCopyOfValuesCache.put(split[0], new KeyValue(split[0], split[1], lineNr));
            }
        }
        if (localCopyOfValuesCache.get("data") == null) {
            localCopyOfValuesCache.put("data", new KeyValue("data", "auto", lineNr));
        }
        PlotState newPlotState = new PlotState(lineNr, localCopyOfValuesCache);
        return newPlotState;
    }

    private void createKeyValueAssignment(String line, int lineNr) {
        String[] split = line.split("=");
        if (split.length == 1) {
            split = new String[]{split[0], ""};
        }
        if (split[0].matches("grid.width")) {
            this.parserResult.addPlotGridValue(split[0], new KeyValue(split[0], split[1], lineNr));
        } else {
            this.tempPlotValuesCache.put(split[0], new KeyValue(split[0], split[1], lineNr));
        }
    }

    private HashMap<String, KeyValue> copyHashMap(HashMap<String, KeyValue> inputHashMap) {
        HashMap<String, KeyValue> returnHashMap = new HashMap<String, KeyValue>();
        for (Map.Entry<String, KeyValue> entry : inputHashMap.entrySet()) {
            returnHashMap.put(entry.getKey(), entry.getValue());
        }
        return returnHashMap;
    }
}

