/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific.sequence_aio;

import com.baselet.control.basics.geom.Line;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.element.facet.specific.sequence_aio.DrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.HorizontalDrawingInfo;
import com.baselet.element.facet.specific.sequence_aio.Lifeline;
import com.baselet.element.facet.specific.sequence_aio.LifelineSpanningTickSpanningOccurrence;
import com.baselet.element.facet.specific.sequence_aio.OccurrenceSpecification;
import com.baselet.element.relation.helper.RelationDrawer;
import java.util.HashMap;
import java.util.Map;

public class GeneralOrdering
implements LifelineSpanningTickSpanningOccurrence {
    private final Lifeline[] coveredLifelines;
    private final OccurrenceSpecification earlierOccurrence;
    private final OccurrenceSpecification laterOccurrence;

    public GeneralOrdering(OccurrenceSpecification earlierOccurrence, OccurrenceSpecification laterOccurrence, Lifeline[] coveredLifelines) {
        if (coveredLifelines.length < 2) {
            throw new IllegalArgumentException("A GeneralOrdering must affect two different lifelines.");
        }
        this.coveredLifelines = coveredLifelines;
        this.earlierOccurrence = earlierOccurrence;
        this.laterOccurrence = laterOccurrence;
    }

    @Override
    public Lifeline getFirstLifeline() {
        return this.coveredLifelines[0];
    }

    @Override
    public Lifeline getLastLifeline() {
        return this.coveredLifelines[this.coveredLifelines.length - 1];
    }

    @Override
    public void draw(DrawHandler drawHandler, DrawingInfo drawingInfo) {
        LineType oldLt = drawHandler.getLineType();
        drawHandler.setLineType(LineType.DASHED);
        Line line = new Line(this.earlierOccurrence.getPosition(drawingInfo), this.laterOccurrence.getPosition(drawingInfo));
        drawHandler.drawLine(line);
        drawHandler.setLineType(oldLt);
        RelationDrawer.drawArrowToLine(line.getCenter(), drawHandler, line, false, RelationDrawer.ArrowEndType.NORMAL, false, false);
    }

    @Override
    public double getOverallMinWidth(DrawHandler drawHandler, double lifelineHorizontalPadding) {
        return 39.0;
    }

    @Override
    public Map<Integer, Double> getEveryAdditionalYHeight(DrawHandler drawHandler, HorizontalDrawingInfo hInfo, double defaultTickHeight) {
        return new HashMap<Integer, Double>();
    }

    @Override
    public LifelineSpanningTickSpanningOccurrence.ContainerPadding getPaddingInformation() {
        return null;
    }
}

