/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.Main;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.rubinius.ArrayPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.BignumPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.DirPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.EncodingConverterPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.EncodingPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.ExceptionPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.FixnumPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.FloatPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.IOBufferPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.IOPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.NativeFunctionPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.PointerPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.RandomizerPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.RegexpPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveCallConstructor;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveConstructor;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNodeConstructor;
import org.jruby.truffle.nodes.rubinius.StatPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.SymbolPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.ThreadPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.TimePrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.UndefinedPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.VMPrimitiveNodesFactory;
import org.jruby.truffle.nodes.rubinius.WeakRefPrimitiveNodesFactory;

public class RubiniusPrimitiveManager {
    private final ConcurrentMap<String, RubiniusPrimitiveConstructor> primitives = new ConcurrentHashMap<String, RubiniusPrimitiveConstructor>();

    public RubiniusPrimitiveConstructor getPrimitive(String name) {
        RubiniusPrimitiveConstructor constructor = (RubiniusPrimitiveConstructor)this.primitives.get(name);
        if (constructor == null) {
            return (RubiniusPrimitiveConstructor)this.primitives.get("undefined");
        }
        return constructor;
    }

    public void addAnnotatedPrimitives() {
        ArrayList<NodeFactory<RubyNode>> nodeFactories = new ArrayList<NodeFactory<RubyNode>>();
        Main.printTruffleTimeMetric((String)"before-load-rubinius-nodes");
        nodeFactories.addAll(VMPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(ObjectPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(TimePrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(StringPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(SymbolPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(FixnumPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(BignumPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(FloatPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(EncodingPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(EncodingConverterPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(RegexpPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(RandomizerPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(ArrayPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(StatPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(PointerPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(NativeFunctionPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(DirPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(IOPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(IOBufferPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(ExceptionPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(ThreadPrimitiveNodesFactory.getFactories());
        nodeFactories.addAll(WeakRefPrimitiveNodesFactory.getFactories());
        Main.printTruffleTimeMetric((String)"after-load-rubinius-nodes");
        nodeFactories.addAll(UndefinedPrimitiveNodesFactory.getFactories());
        for (NodeFactory nodeFactory : nodeFactories) {
            GeneratedBy generatedBy = nodeFactory.getClass().getAnnotation(GeneratedBy.class);
            Class<?> nodeClass = generatedBy.value();
            RubiniusPrimitive annotation = nodeClass.getAnnotation(RubiniusPrimitive.class);
            this.primitives.putIfAbsent(annotation.name(), new RubiniusPrimitiveNodeConstructor(annotation, nodeFactory));
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void installPrimitive(String name, DynamicObject method) {
        assert (RubyGuards.isRubyMethod(method));
        this.primitives.put(name, new RubiniusPrimitiveCallConstructor(method));
    }
}

