/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.Calc.NLPSolver;

import com.sun.star.awt.XReschedule;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertyChangeListener;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.beans.XVetoableChangeListener;
import com.sun.star.chart.XChartDataArray;
import com.sun.star.comp.Calc.NLPSolver.PropertyInfo;
import com.sun.star.comp.Calc.NLPSolver.ResourceManager;
import com.sun.star.container.XIndexAccess;
import com.sun.star.document.XEmbeddedObjectSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XLocalizable;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.sheet.SolverConstraint;
import com.sun.star.sheet.SolverConstraintOperator;
import com.sun.star.sheet.XSolver;
import com.sun.star.sheet.XSolverDescription;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.CellAddress;
import com.sun.star.table.CellContentType;
import com.sun.star.table.CellRangeAddress;
import com.sun.star.table.XCell;
import com.sun.star.table.XTableChartsSupplier;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseNLPSolver
extends WeakBase
implements XLocalizable,
XSolver,
XSolverDescription,
XPropertySet,
XPropertySetInfo {
    protected final XComponentContext m_xContext;
    private final String m_name;
    private final ArrayList<PropertyInfo> m_properties = new ArrayList();
    private final HashMap<String, PropertyInfo> m_propertyMap = new HashMap();
    private Locale m_locale = new Locale();
    private final ResourceManager resourceManager;
    private CellAddress m_objective;
    protected CellAddress[] m_variables;
    protected SolverConstraint[] m_constraints;
    private XSpreadsheetDocument m_document;
    private XModel m_xModel;
    protected XReschedule m_xReschedule;
    protected ExtSolverConstraint[] m_extConstraints;
    protected boolean m_maximize;
    protected int m_variableCount;
    protected int m_constraintCount;
    protected int m_cellRangeCount;
    protected XCell m_objectiveCell;
    protected XCell[] m_variableCells;
    protected XChartDataArray[] m_cellRangeData;
    protected CellMap[] m_variableMap;
    protected double[][][] m_variableData;
    protected double m_functionValue;
    protected double[] m_currentParameters;
    protected boolean m_success = false;
    protected PropertyInfo<Boolean> m_assumeNonNegative = new PropertyInfo<Boolean>("AssumeNonNegative", false, "Assume Non-Negative Variables");

    public BaseNLPSolver(XComponentContext xContext, String name) {
        this.m_xContext = xContext;
        this.m_name = name;
        this.m_objective = new CellAddress();
        this.m_variables = new CellAddress[0];
        this.m_constraints = new SolverConstraint[0];
        XMultiComponentFactory componentFactory = xContext.getServiceManager();
        try {
            Object toolkit = componentFactory.createInstanceWithContext("com.sun.star.awt.Toolkit", xContext);
            this.m_xReschedule = (XReschedule)UnoRuntime.queryInterface(XReschedule.class, (Object)toolkit);
        }
        catch (Exception ex) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.resourceManager = new ResourceManager(xContext, "com.sun.star.comp.Calc.NLPSolver", "/locale", "NLPSolverCommon");
        this.registerProperty(this.m_assumeNonNegative);
    }

    protected void registerProperty(PropertyInfo property) {
        this.m_properties.add(property);
        this.m_propertyMap.put(property.getProperty().Name, property);
        property.localize(this.resourceManager);
    }

    public void setLocale(Locale eLocale) {
        this.m_locale = eLocale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public XSpreadsheetDocument getDocument() {
        return this.m_document;
    }

    public void setDocument(XSpreadsheetDocument document) {
        this.m_document = document;
        this.m_xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.m_document);
    }

    public CellAddress getObjective() {
        return this.m_objective;
    }

    public void setObjective(CellAddress objective) {
        this.m_objective = objective;
        this.m_objectiveCell = this.getCell(objective);
    }

    public CellAddress[] getVariables() {
        return this.m_variables;
    }

    public void setVariables(CellAddress[] variables) {
        this.m_variables = variables;
        this.m_variableCount = variables.length;
        this.m_variableCells = new XCell[this.m_variableCount];
        this.m_currentParameters = new double[this.m_variableCount];
        for (int i = 0; i < this.m_variableCount; ++i) {
            this.m_variableCells[i] = this.getCell(variables[i]);
            this.m_currentParameters[i] = this.m_variableCells[i].getValue();
        }
        this.m_variableMap = new CellMap[this.m_variableCount];
        this.m_variableData = new double[this.m_variableCount][][];
        ArrayList<RowInfo> rows = new ArrayList<RowInfo>();
        RowInfo currentRow = null;
        short lastSheet = -1;
        int lastRow = -1;
        for (int i = 0; i < this.m_variableCount; ++i) {
            if (lastSheet == this.m_variables[i].Sheet && lastRow == this.m_variables[i].Row && currentRow.EndCol == this.m_variables[i].Column - 1) {
                currentRow.EndCol++;
                continue;
            }
            currentRow = new RowInfo(this.m_variables[i].Sheet, this.m_variables[i].Row);
            currentRow.StartCol = this.m_variables[i].Column;
            currentRow.EndCol = this.m_variables[i].Column;
            rows.add(currentRow);
            lastSheet = currentRow.Sheet;
            lastRow = currentRow.Row;
        }
        ArrayList<CellRangeAddress> cellRangeAddresses = new ArrayList<CellRangeAddress>();
        if (rows.size() > 0) {
            RowInfo firstRow = (RowInfo)rows.get(0);
            int offset = 0;
            for (int i = 1; i < rows.size(); ++i) {
                currentRow = (RowInfo)rows.get(i);
                if (currentRow.Sheet != firstRow.Sheet || currentRow.Row != firstRow.Row + offset + 1 || currentRow.StartCol != firstRow.StartCol || currentRow.EndCol != firstRow.EndCol) {
                    cellRangeAddresses.add(firstRow.getCellRangeAddress(firstRow.Row + offset));
                    firstRow = currentRow;
                    offset = 0;
                    continue;
                }
                ++offset;
            }
            cellRangeAddresses.add(firstRow.getCellRangeAddress(firstRow.Row + offset));
        }
        this.m_cellRangeCount = cellRangeAddresses.size();
        this.m_cellRangeData = new XChartDataArray[this.m_cellRangeCount];
        int varID = 0;
        for (int i = 0; i < this.m_cellRangeCount; ++i) {
            for (int y = 0; y <= ((CellRangeAddress)cellRangeAddresses.get((int)i)).EndRow - ((CellRangeAddress)cellRangeAddresses.get((int)i)).StartRow; ++y) {
                int x = 0;
                while (x <= ((CellRangeAddress)cellRangeAddresses.get((int)i)).EndColumn - ((CellRangeAddress)cellRangeAddresses.get((int)i)).StartColumn) {
                    CellMap map = new CellMap();
                    this.m_variableMap[varID++] = map;
                    map.Range = i;
                    map.Col = x++;
                    map.Row = y;
                }
            }
            this.m_cellRangeData[i] = this.getChartDataArray((CellRangeAddress)cellRangeAddresses.get(i));
            this.m_variableData[i] = this.m_cellRangeData[i].getData();
        }
    }

    public SolverConstraint[] getConstraints() {
        return this.m_constraints;
    }

    public void setConstraints(SolverConstraint[] constraints) {
        this.m_constraints = constraints;
        this.m_constraintCount = constraints.length;
        this.m_extConstraints = new ExtSolverConstraint[this.m_constraintCount];
        for (int i = 0; i < this.m_constraintCount; ++i) {
            this.m_extConstraints[i] = new ExtSolverConstraint(this.getCell(constraints[i].Left), constraints[i].Operator, constraints[i].Right);
        }
    }

    public boolean getMaximize() {
        return this.m_maximize;
    }

    public void setMaximize(boolean maximize) {
        this.m_maximize = maximize;
    }

    public boolean getSuccess() {
        return this.m_success;
    }

    public double getResultValue() {
        return this.m_functionValue;
    }

    public double[] getSolution() {
        return this.m_currentParameters;
    }

    private XCell getCell(CellAddress cellAddress) {
        return this.getCell(cellAddress.Column, cellAddress.Row, cellAddress.Sheet);
    }

    private XCell getCell(int col, int row, int sheet) {
        try {
            XSpreadsheets xSpreadsheets = this.m_document.getSheets();
            XIndexAccess xSheetIndex = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            XSpreadsheet xSpreadsheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, (Object)xSheetIndex.getByIndex(sheet));
            return xSpreadsheet.getCellByPosition(col, row);
        }
        catch (IndexOutOfBoundsException ex) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (WrappedTargetException ex) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private XChartDataArray getChartDataArray(CellRangeAddress cellRangeAddress) {
        return this.getChartDataArray(cellRangeAddress.Sheet, cellRangeAddress.StartColumn, cellRangeAddress.StartRow, cellRangeAddress.EndColumn, cellRangeAddress.EndRow);
    }

    private XChartDataArray getChartDataArray(int sheet, int startCol, int startRow, int endCol, int endRow) {
        try {
            XSpreadsheets xSpreadsheets = this.m_document.getSheets();
            XIndexAccess xSheetIndex = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            XSpreadsheet xSpreadsheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, (Object)xSheetIndex.getByIndex(sheet));
            return (XChartDataArray)UnoRuntime.queryInterface(XChartDataArray.class, (Object)xSpreadsheet.getCellRangeByPosition(startCol, startRow, endCol, endRow));
        }
        catch (IndexOutOfBoundsException ex) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (WrappedTargetException ex) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    protected void initializeSolve() {
        this.lockDocument();
    }

    protected void finalizeSolve() {
        this.unlockDocument();
    }

    public String getComponentDescription() {
        return this.m_name;
    }

    public String getStatusDescription() {
        return "";
    }

    public String getPropertyDescription(String property) {
        PropertyInfo propertyInfo = this.m_propertyMap.get(property);
        if (propertyInfo != null) {
            return propertyInfo.getDescription();
        }
        return "";
    }

    public XPropertySetInfo getPropertySetInfo() {
        return this;
    }

    public void setPropertyValue(String property, Object value) throws UnknownPropertyException, PropertyVetoException, IllegalArgumentException, WrappedTargetException {
        PropertyInfo propertyInfo = this.m_propertyMap.get(property);
        if (propertyInfo == null) {
            throw new UnknownPropertyException();
        }
        propertyInfo.setValue(value);
    }

    public Object getPropertyValue(String property) throws UnknownPropertyException, WrappedTargetException {
        PropertyInfo propertyInfo = this.m_propertyMap.get(property);
        if (propertyInfo != null) {
            return propertyInfo.getValue();
        }
        throw new UnknownPropertyException();
    }

    public void addPropertyChangeListener(String property, XPropertyChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(String property, XPropertyChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addVetoableChangeListener(String property, XVetoableChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removeVetoableChangeListener(String property, XVetoableChangeListener listener) throws UnknownPropertyException, WrappedTargetException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Property[] getProperties() {
        int propertyCount = this.m_properties.size();
        Property[] properties = new Property[propertyCount];
        for (int i = 0; i < propertyCount; ++i) {
            properties[i] = this.m_properties.get(i).getProperty();
        }
        return properties;
    }

    public Property getPropertyByName(String property) throws UnknownPropertyException {
        PropertyInfo propertyInfo = this.m_propertyMap.get(property);
        if (propertyInfo != null) {
            return propertyInfo.getProperty();
        }
        throw new UnknownPropertyException();
    }

    public boolean hasPropertyByName(String property) {
        return this.m_propertyMap.containsKey(property);
    }

    private void lockDocument(boolean lock) {
        if (lock) {
            this.m_xModel.lockControllers();
        } else {
            this.m_xModel.unlockControllers();
        }
        try {
            XIndexAccess xSpreadsheets = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)this.m_document.getSheets());
            int sheets = xSpreadsheets.getCount();
            for (int i = 0; i < sheets; ++i) {
                Object sheet = xSpreadsheets.getByIndex(i);
                XTableChartsSupplier xTableChartsSupplier = (XTableChartsSupplier)UnoRuntime.queryInterface(XTableChartsSupplier.class, (Object)sheet);
                XIndexAccess xCharts = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xTableChartsSupplier.getCharts());
                int charts = xCharts.getCount();
                for (int j = 0; j < charts; ++j) {
                    Object chart = xCharts.getByIndex(j);
                    XEmbeddedObjectSupplier xChartObjects = (XEmbeddedObjectSupplier)UnoRuntime.queryInterface(XEmbeddedObjectSupplier.class, (Object)chart);
                    XModel xChartModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xChartObjects.getEmbeddedObject());
                    if (lock) {
                        xChartModel.lockControllers();
                        continue;
                    }
                    xChartModel.unlockControllers();
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(BaseNLPSolver.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void lockDocument() {
        this.lockDocument(true);
    }

    protected void unlockDocument() {
        this.lockDocument(false);
    }

    public static String nanoTimeToString(ResourceManager resourceManager, long nanoseconds) {
        if (nanoseconds < 0L) {
            return null;
        }
        if (nanoseconds == 0L) {
            return "0";
        }
        if (nanoseconds < 1000L) {
            return nanoseconds + " " + resourceManager.getLocalizedString("Time.Nanoseconds", "Nanoseconds");
        }
        double microseconds = (double)nanoseconds / 1000.0;
        if (microseconds < 1000.0) {
            return String.format("%.2f %s", microseconds, resourceManager.getLocalizedString("Time.Microseconds", "Microseconds"));
        }
        double milliseconds = microseconds / 1000.0;
        if (milliseconds < 1000.0) {
            return String.format("%.2f %s", milliseconds, resourceManager.getLocalizedString("Time.Milliseconds", "Milliseconds"));
        }
        double seconds = milliseconds / 1000.0;
        if (seconds < 90.0) {
            return String.format("%.2f %s", seconds, resourceManager.getLocalizedString("Time.Seconds", "Seconds"));
        }
        long minutes = (long)seconds / 60L;
        seconds -= (double)(minutes * 60L);
        long hours = minutes / 60L;
        minutes -= hours * 60L;
        long days = hours / 24L;
        hours -= days * 24L;
        if (days > 0L) {
            return String.format("%d %s, %d %s", days, resourceManager.getLocalizedString(String.format("Time.Day%s", days == 1L ? "" : "s"), "Days"), hours, resourceManager.getLocalizedString(String.format("Time.Hour%s", hours == 1L ? "" : "s"), "Hours"));
        }
        if (hours > 0L) {
            return String.format("%d %s, %d %s", hours, resourceManager.getLocalizedString(String.format("Time.Hour%s", hours == 1L ? "" : "s"), "Hours"), minutes, resourceManager.getLocalizedString(String.format("Time.Minute%s", minutes == 1L ? "" : "s"), "Minutes"));
        }
        if (minutes > 0L) {
            return String.format("%d %s, %.0f %s", minutes, resourceManager.getLocalizedString(String.format("Time.Minute%s", minutes == 1L ? "" : "s"), "Minutes"), Math.floor(seconds), resourceManager.getLocalizedString(String.format("Time.Second%s", Math.floor(seconds) == 1.0 ? "" : "s"), "Seconds"));
        }
        return String.format("%.2f %s", seconds, resourceManager.getLocalizedString("Time.Seconds", "Seconds"));
    }

    protected class ExtSolverConstraint {
        public XCell Left;
        public SolverConstraintOperator Operator;
        public XCell Right;
        public double Data;

        private ExtSolverConstraint(XCell left, SolverConstraintOperator operator, Object right) {
            this.Left = left;
            this.Operator = operator;
            this.Right = null;
            if (right instanceof Number) {
                this.Data = ((Number)right).doubleValue();
            } else if (right instanceof CellAddress) {
                XCell cell = BaseNLPSolver.this.getCell((CellAddress)right);
                if (cell.getType() == CellContentType.VALUE) {
                    this.Data = cell.getValue();
                } else {
                    this.Right = cell;
                    this.Data = 0.0;
                }
            }
        }

        public double getLeftValue() {
            if (this.Right == null) {
                return this.Left.getValue();
            }
            return this.Left.getValue() - this.Right.getValue();
        }
    }

    protected class CellMap {
        protected int Range;
        protected int Col;
        protected int Row;

        protected CellMap() {
        }
    }

    private class RowInfo {
        private short Sheet;
        private int Row;
        private int StartCol;
        private int EndCol;

        private RowInfo(short sheet, int row) {
            this.Sheet = sheet;
            this.Row = row;
        }

        private CellRangeAddress getCellRangeAddress(int lastRow) {
            CellRangeAddress result = new CellRangeAddress();
            result.Sheet = this.Sheet;
            result.StartColumn = this.StartCol;
            result.StartRow = this.Row;
            result.EndColumn = this.EndCol;
            result.EndRow = lastRow;
            return result;
        }
    }
}

