/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.report.modules.data.sql;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.jfree.report.DataSourceException;
import org.jfree.report.ReportData;

public class SQLReportData
implements ReportData {
    private ResultSet resultSet;
    private int rowCount;
    private int columnCount;
    private int cursor;
    private String[] columnNames;
    private boolean labelMapping;

    public SQLReportData(ResultSet resultSet, boolean bl) throws SQLException, DataSourceException {
        if (resultSet == null) {
            throw new NullPointerException();
        }
        if (resultSet.getType() == 1003) {
            throw new IllegalArgumentException();
        }
        this.resultSet = resultSet;
        this.labelMapping = bl;
        this.rowCount = resultSet.last() ? resultSet.getRow() : 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.columnCount = resultSetMetaData.getColumnCount();
        this.columnNames = new String[this.columnCount];
        for (int i = 1; i <= this.columnCount; ++i) {
            this.columnNames[i - 1] = bl ? resultSetMetaData.getColumnLabel(i) : resultSetMetaData.getColumnName(i);
        }
        if (!resultSet.first()) {
            throw new DataSourceException("Unable to reset the dataset.");
        }
        this.cursor = 0;
    }

    public boolean isLabelMapping() {
        return this.labelMapping;
    }

    public int getRowCount() throws DataSourceException {
        return this.rowCount;
    }

    public boolean isAdvanceable() throws DataSourceException {
        return this.cursor < this.rowCount;
    }

    public int getColumnCount() throws DataSourceException {
        return this.columnCount;
    }

    public boolean setCursorPosition(int n) throws DataSourceException {
        if (n < 0) {
            throw new DataSourceException("Negative row number is not valid");
        }
        if (n > this.rowCount) {
            return false;
        }
        try {
            if (this.cursor == 0) {
                this.resultSet.beforeFirst();
                return true;
            }
            if (this.resultSet.absolute(n)) {
                this.cursor = n;
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Failed to move the cursor: ", sQLException);
        }
    }

    public boolean next() throws DataSourceException {
        try {
            if (this.resultSet.next()) {
                ++this.cursor;
                return true;
            }
            return false;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Failed to move the cursor: ", sQLException);
        }
    }

    public void close() throws DataSourceException {
        try {
            this.resultSet.close();
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Failed to close the resultset: ", sQLException);
        }
    }

    public String getColumnName(int n) throws DataSourceException {
        return this.columnNames[n];
    }

    public Object get(int n) throws DataSourceException {
        if (!this.isReadable()) {
            throw new DataSourceException("Cannot read from this datasource");
        }
        try {
            Object object = this.resultSet.getObject(n + 1);
            if (this.resultSet.wasNull()) {
                return null;
            }
            return object;
        }
        catch (SQLException sQLException) {
            throw new DataSourceException("Failed to query data", sQLException);
        }
    }

    public int getCursorPosition() throws DataSourceException {
        return this.cursor;
    }

    public boolean isReadable() throws DataSourceException {
        return this.cursor > 0 && this.rowCount > 0;
    }
}

