/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultsProvider;
import org.netbeans.lib.profiler.results.cpu.CPUDataFrameProcessor;
import org.netbeans.lib.profiler.results.cpu.CPUProfilingResultListener;
import org.netbeans.lib.profiler.results.cpu.CPUSamplingDataFrameProcessor;
import org.netbeans.lib.profiler.results.locks.LockDataFrameProcessor;
import org.netbeans.lib.profiler.results.locks.LockProfilingResultListener;
import org.netbeans.lib.profiler.results.memory.MemoryDataFrameProcessor;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;

public final class ProfilingResultsDispatcher
implements ProfilingResultsProvider.Dispatcher {
    private static final Logger LOGGER = Logger.getLogger(ProfilingResultsDispatcher.class.getName());
    private static final int QLengthLowerBound = 13;
    private static final int QLengthUpperBound = 15;
    private static ProfilingResultsDispatcher instance;
    private final AbstractDataFrameProcessor cpuDataProcessor = new CPUDataFrameProcessor();
    private final AbstractDataFrameProcessor cpuSamplingDataProcessor = new CPUSamplingDataFrameProcessor();
    private final AbstractDataFrameProcessor memoryDataProcessor = new MemoryDataFrameProcessor();
    private final AbstractDataFrameProcessor lockDataProcessor = new LockDataFrameProcessor();
    private final Object cpuDataProcessorQLengthLock = new Object();
    private final Object memDataProcessorQLengthLock = new Object();
    private final Object lockDataProcessorQLengthLock = new Object();
    private ExecutorService queueProcessor;
    private volatile boolean pauseFlag = true;
    private int cpuDataProcessorQLength = 0;
    private int memDataProcessorQLength = 0;
    private int lockDataProcessorQLength = 0;

    public static synchronized ProfilingResultsDispatcher getDefault() {
        if (instance == null) {
            instance = new ProfilingResultsDispatcher();
        }
        return instance;
    }

    public void addListener(CPUProfilingResultListener cPUProfilingResultListener) {
        this.cpuDataProcessor.addListener(cPUProfilingResultListener);
        this.cpuSamplingDataProcessor.addListener(cPUProfilingResultListener);
    }

    public void addListener(MemoryProfilingResultsListener memoryProfilingResultsListener) {
        this.memoryDataProcessor.addListener(memoryProfilingResultsListener);
    }

    public void addListener(LockProfilingResultListener lockProfilingResultListener) {
        this.lockDataProcessor.addListener(lockProfilingResultListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dataFrameReceived(final byte[] byArray, int n) {
        if (!(this.cpuDataProcessor.hasListeners() || this.memoryDataProcessor.hasListeners() || this.cpuSamplingDataProcessor.hasListeners() || this.lockDataProcessor.hasListeners())) {
            return;
        }
        switch (n) {
            case 3: 
            case 4: {
                Object object = this.cpuDataProcessorQLengthLock;
                synchronized (object) {
                    ++this.cpuDataProcessorQLength;
                    if (this.cpuDataProcessorQLength > 15) {
                        try {
                            this.cpuDataProcessorQLengthLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.getExecutor().submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ProfilingResultsDispatcher.this.cpuDataProcessor.processDataFrame(byArray);
                            }
                            finally {
                                Object object = ProfilingResultsDispatcher.this.cpuDataProcessorQLengthLock;
                                synchronized (object) {
                                    ProfilingResultsDispatcher.this.cpuDataProcessorQLength--;
                                    if (ProfilingResultsDispatcher.this.cpuDataProcessorQLength < 13) {
                                        ProfilingResultsDispatcher.this.cpuDataProcessorQLengthLock.notifyAll();
                                    }
                                }
                            }
                        }
                    });
                    break;
                }
            }
            case 5: 
            case 6: {
                Object object = this.memDataProcessorQLengthLock;
                synchronized (object) {
                    ++this.memDataProcessorQLength;
                    if (this.memDataProcessorQLength > 15) {
                        try {
                            this.memDataProcessorQLengthLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.getExecutor().submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ProfilingResultsDispatcher.this.memoryDataProcessor.processDataFrame(byArray);
                            }
                            finally {
                                Object object = ProfilingResultsDispatcher.this.memDataProcessorQLengthLock;
                                synchronized (object) {
                                    ProfilingResultsDispatcher.this.memDataProcessorQLength--;
                                    if (ProfilingResultsDispatcher.this.memDataProcessorQLength < 13) {
                                        ProfilingResultsDispatcher.this.memDataProcessorQLengthLock.notifyAll();
                                    }
                                }
                            }
                        }
                    });
                    break;
                }
            }
            case 2: {
                Object object = this.cpuDataProcessorQLengthLock;
                synchronized (object) {
                    ++this.cpuDataProcessorQLength;
                    if (this.cpuDataProcessorQLength > 15) {
                        try {
                            this.cpuDataProcessorQLengthLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.getExecutor().submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ProfilingResultsDispatcher.this.cpuSamplingDataProcessor.processDataFrame(byArray);
                            }
                            finally {
                                Object object = ProfilingResultsDispatcher.this.cpuDataProcessorQLengthLock;
                                synchronized (object) {
                                    ProfilingResultsDispatcher.this.cpuDataProcessorQLength--;
                                    if (ProfilingResultsDispatcher.this.cpuDataProcessorQLength < 13) {
                                        ProfilingResultsDispatcher.this.cpuDataProcessorQLengthLock.notifyAll();
                                    }
                                }
                            }
                        }
                    });
                    break;
                }
            }
            default: {
                Object object = this.lockDataProcessorQLengthLock;
                synchronized (object) {
                    ++this.lockDataProcessorQLength;
                    if (this.lockDataProcessorQLength > 15) {
                        try {
                            this.lockDataProcessorQLengthLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.getExecutor().submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                ProfilingResultsDispatcher.this.lockDataProcessor.processDataFrame(byArray);
                            }
                            finally {
                                Object object = ProfilingResultsDispatcher.this.lockDataProcessorQLengthLock;
                                synchronized (object) {
                                    ProfilingResultsDispatcher.this.lockDataProcessorQLength--;
                                    if (ProfilingResultsDispatcher.this.lockDataProcessorQLength < 13) {
                                        ProfilingResultsDispatcher.this.lockDataProcessorQLengthLock.notifyAll();
                                    }
                                }
                            }
                        }
                    });
                    break;
                }
            }
        }
    }

    @Override
    public void pause(boolean bl) {
        this.pauseFlag = true;
    }

    public void removeAllListeners() {
        this.cpuDataProcessor.removeAllListeners();
        this.cpuSamplingDataProcessor.removeAllListeners();
        this.memoryDataProcessor.removeAllListeners();
        this.lockDataProcessor.removeAllListeners();
    }

    public void removeListener(CPUProfilingResultListener cPUProfilingResultListener) {
        this.cpuDataProcessor.removeListener(cPUProfilingResultListener);
        this.cpuSamplingDataProcessor.removeListener(cPUProfilingResultListener);
    }

    public void removeListener(MemoryProfilingResultsListener memoryProfilingResultsListener) {
        this.memoryDataProcessor.removeListener(memoryProfilingResultsListener);
    }

    public void removeListener(LockProfilingResultListener lockProfilingResultListener) {
        this.lockDataProcessor.removeListener(lockProfilingResultListener);
    }

    @Override
    public void reset() {
        this.fireReset();
    }

    @Override
    public void resume() {
        this.pauseFlag = false;
    }

    @Override
    public synchronized void shutdown() {
        this.fireShutdown();
        this.removeAllListeners();
    }

    @Override
    public synchronized void startup(ProfilerClient profilerClient) {
        this.fireStartup(profilerClient);
        this.resume();
    }

    private synchronized ExecutorService getExecutor() {
        if (this.queueProcessor == null) {
            this.queueProcessor = Executors.newSingleThreadExecutor();
        }
        return this.queueProcessor;
    }

    private synchronized void fireReset() {
        this.cpuDataProcessor.reset();
        this.cpuSamplingDataProcessor.reset();
        this.memoryDataProcessor.reset();
        this.lockDataProcessor.reset();
    }

    private synchronized void fireShutdown() {
        this.cpuDataProcessor.shutdown();
        this.cpuSamplingDataProcessor.shutdown();
        this.memoryDataProcessor.shutdown();
        this.lockDataProcessor.shutdown();
    }

    private synchronized void fireStartup(ProfilerClient profilerClient) {
        this.cpuSamplingDataProcessor.startup(profilerClient);
        this.cpuDataProcessor.startup(profilerClient);
        this.memoryDataProcessor.startup(profilerClient);
        this.lockDataProcessor.startup(profilerClient);
    }
}

