/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.queries.function.ValueSource;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.script.expression.FieldDataFunctionValues;
import org.elasticsearch.search.MultiValueMode;

class DateMethodFunctionValues
extends FieldDataFunctionValues {
    private final int calendarType;
    private final Calendar calendar;

    DateMethodFunctionValues(ValueSource parent, MultiValueMode multiValueMode, AtomicNumericFieldData data, int calendarType) {
        super(parent, multiValueMode, data);
        this.calendarType = calendarType;
        this.calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
    }

    @Override
    public double doubleVal(int docId) {
        long millis = (long)this.dataAccessor.get(docId);
        this.calendar.setTimeInMillis(millis);
        return this.calendar.get(this.calendarType);
    }
}

