/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.aliases;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.indices.AliasFilterParsingException;
import org.elasticsearch.indices.InvalidAliasNameException;

public class IndexAliasesService
extends AbstractIndexComponent {
    private final IndexQueryParserService indexQueryParser;
    private volatile ImmutableOpenMap<String, AliasMetaData> aliases = ImmutableOpenMap.of();

    @Inject
    public IndexAliasesService(Index index, IndexSettingsService indexSettingsService, IndexQueryParserService indexQueryParser) {
        super(index, indexSettingsService.getSettings());
        this.indexQueryParser = indexQueryParser;
    }

    public Query aliasFilter(String ... aliasNames) {
        if (aliasNames == null || aliasNames.length == 0) {
            return null;
        }
        if (aliasNames.length == 1) {
            AliasMetaData alias = this.aliases.get(aliasNames[0]);
            if (alias == null) {
                throw new InvalidAliasNameException(this.index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            return this.parse(alias);
        }
        BooleanQuery.Builder combined = new BooleanQuery.Builder();
        for (String aliasName : aliasNames) {
            AliasMetaData alias = this.aliases.get(aliasName);
            if (alias == null) {
                throw new InvalidAliasNameException(this.index, aliasNames[0], "Unknown alias name was passed to alias Filter");
            }
            Query parsedFilter = this.parse(alias);
            if (parsedFilter == null) {
                return null;
            }
            combined.add(parsedFilter, BooleanClause.Occur.SHOULD);
        }
        return combined.build();
    }

    public void setAliases(ImmutableOpenMap<String, AliasMetaData> aliases) {
        this.aliases = aliases;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Query parse(AliasMetaData alias) {
        if (alias.filter() == null) {
            return null;
        }
        try {
            byte[] filterSource = alias.filter().uncompressed();
            try (XContentParser parser = XContentFactory.xContent(filterSource).createParser(filterSource);){
                ParsedQuery parsedFilter = this.indexQueryParser.parseInnerFilter(parser);
                Query query = parsedFilter == null ? null : parsedFilter.query();
                return query;
            }
        }
        catch (IOException ex) {
            throw new AliasFilterParsingException(this.index, alias.getAlias(), "Invalid alias filter", ex);
        }
    }

    void add(String alias, @Nullable CompressedXContent filter) {
        AliasMetaData aliasMetaData = AliasMetaData.builder(alias).filter(filter).build();
        this.aliases = ImmutableOpenMap.builder(this.aliases).fPut(alias, aliasMetaData).build();
    }

    boolean hasAlias(String alias) {
        return this.aliases.containsKey(alias);
    }

    void remove(String alias) {
        this.aliases = ImmutableOpenMap.builder(this.aliases).fRemove(alias).build();
    }
}

