/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.ngram.Lucene43EdgeNGramTokenizer;
import org.elasticsearch.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.analysis.CharMatcher;
import org.elasticsearch.index.analysis.NGramTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class EdgeNGramTokenizerFactory
extends AbstractTokenizerFactory {
    private final int minGram;
    private final int maxGram;
    private final Lucene43EdgeNGramTokenizer.Side side;
    private final CharMatcher matcher;
    protected Version esVersion;

    @Inject
    public EdgeNGramTokenizerFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        this(index, indexSettingsService.getSettings(), name, settings);
    }

    public EdgeNGramTokenizerFactory(Index index, Settings indexSettings, String name, Settings settings) {
        super(index, indexSettings, name, settings);
        this.minGram = settings.getAsInt("min_gram", (Integer)1);
        this.maxGram = settings.getAsInt("max_gram", (Integer)2);
        this.side = Lucene43EdgeNGramTokenizer.Side.getSide((String)settings.get("side", Lucene43EdgeNGramTokenizer.DEFAULT_SIDE.getLabel()));
        this.matcher = NGramTokenizerFactory.parseTokenChars(settings.getAsArray("token_chars"));
        this.esVersion = Version.indexCreated(indexSettings);
    }

    @Override
    public Tokenizer create() {
        if (this.version.onOrAfter(org.apache.lucene.util.Version.LUCENE_4_3) && this.esVersion.onOrAfter(Version.V_0_90_2)) {
            org.apache.lucene.util.Version version;
            if (this.side == Lucene43EdgeNGramTokenizer.Side.BACK) {
                throw new IllegalArgumentException("side=back is not supported anymore. Please fix your analysis chain or use an older compatibility version (<=4.2) but beware that it might cause highlighting bugs. To obtain the same behavior as the previous version please use \"edgeNGram\" filter which still supports side=back in combination with a \"keyword\" tokenizer");
            }
            org.apache.lucene.util.Version version2 = version = this.version == org.apache.lucene.util.Version.LUCENE_4_3 ? org.apache.lucene.util.Version.LUCENE_4_4 : this.version;
            if (this.matcher == null) {
                return new EdgeNGramTokenizer(this.minGram, this.maxGram);
            }
            return new EdgeNGramTokenizer(this.minGram, this.maxGram){

                protected boolean isTokenChar(int chr) {
                    return EdgeNGramTokenizerFactory.this.matcher.isTokenChar(chr);
                }
            };
        }
        return new Lucene43EdgeNGramTokenizer(this.side, this.minGram, this.maxGram);
    }
}

