/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;

public class SpanWithinQueryBuilder
extends SpanQueryBuilder
implements BoostableQueryBuilder<SpanWithinQueryBuilder> {
    private SpanQueryBuilder big;
    private SpanQueryBuilder little;
    private float boost = -1.0f;
    private String queryName;

    public SpanWithinQueryBuilder little(SpanQueryBuilder clause) {
        this.little = clause;
        return this;
    }

    public SpanWithinQueryBuilder big(SpanQueryBuilder clause) {
        this.big = clause;
        return this;
    }

    @Override
    public SpanWithinQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public SpanWithinQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.big == null) {
            throw new IllegalArgumentException("Must specify big clause when building a span_within query");
        }
        if (this.little == null) {
            throw new IllegalArgumentException("Must specify little clause when building a span_within query");
        }
        builder.startObject("span_within");
        builder.field("big");
        this.big.toXContent(builder, params);
        builder.field("little");
        this.little.toXContent(builder, params);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }
}

