/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.monitor.process.ProcessInfo;
import org.elasticsearch.monitor.process.ProcessProbe;
import org.elasticsearch.monitor.process.ProcessStats;

public final class ProcessService
extends AbstractComponent {
    private final ProcessProbe probe;
    private final ProcessInfo info;
    private final SingleObjectCache<ProcessStats> processStatsCache;

    @Inject
    public ProcessService(Settings settings, ProcessProbe probe) {
        super(settings);
        this.probe = probe;
        TimeValue refreshInterval = settings.getAsTime("monitor.process.refresh_interval", TimeValue.timeValueSeconds(1L));
        this.processStatsCache = new ProcessStatsCache(refreshInterval, probe.processStats());
        this.info = probe.processInfo();
        this.info.refreshInterval = refreshInterval.millis();
        this.logger.debug("Using probe [{}] with refresh_interval [{}]", probe, refreshInterval);
    }

    public ProcessInfo info() {
        return this.info;
    }

    public ProcessStats stats() {
        return this.processStatsCache.getOrRefresh();
    }

    private class ProcessStatsCache
    extends SingleObjectCache<ProcessStats> {
        public ProcessStatsCache(TimeValue interval, ProcessStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected ProcessStats refresh() {
            return ProcessService.this.probe.processStats();
        }
    }
}

