/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;

public abstract class Aggregator
extends BucketCollector
implements Releasable {
    public static boolean descendsFromBucketAggregator(Aggregator parent) {
        while (parent != null) {
            if (parent instanceof BucketsAggregator) {
                return true;
            }
            parent = parent.parent();
        }
        return false;
    }

    public abstract String name();

    public abstract AggregationContext context();

    public abstract Aggregator parent();

    public abstract Aggregator subAggregator(String var1);

    public abstract InternalAggregation buildAggregation(long var1) throws IOException;

    public abstract InternalAggregation buildEmptyAggregation();

    public static enum SubAggCollectionMode {
        DEPTH_FIRST(new ParseField("depth_first", new String[0])),
        BREADTH_FIRST(new ParseField("breadth_first", new String[0]));

        public static final ParseField KEY;
        private final ParseField parseField;

        private SubAggCollectionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        public ParseField parseField() {
            return this.parseField;
        }

        public static SubAggCollectionMode parse(String value, ParseFieldMatcher parseFieldMatcher) {
            SubAggCollectionMode[] modes;
            for (SubAggCollectionMode mode : modes = SubAggCollectionMode.values()) {
                if (!parseFieldMatcher.match(value, mode.parseField)) continue;
                return mode;
            }
            throw new ElasticsearchParseException("no [{}] found for value [{}]", KEY.getPreferredName(), value);
        }

        static {
            KEY = new ParseField("collect_mode", new String[0]);
        }
    }

    public static interface Parser {
        public String type();

        public AggregatorFactory parse(String var1, XContentParser var2, SearchContext var3) throws IOException;
    }
}

