/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BestDocsDeferringCollector;
import org.elasticsearch.search.aggregations.bucket.DeferringBucketCollector;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedBytesHashSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedMapSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedNumericSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedOrdinalsSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.InternalSampler;
import org.elasticsearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class SamplerAggregator
extends SingleBucketAggregator {
    protected final int shardSize;
    protected BestDocsDeferringCollector bdd;

    public SamplerAggregator(String name, int shardSize, AggregatorFactories factories, AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        this.shardSize = shardSize;
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new BestDocsDeferringCollector(this.shardSize, this.context.bigArrays());
        return this.bdd;
    }

    @Override
    protected boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        this.runDeferredCollections(owningBucketOrdinal);
        return new InternalSampler(this.name, this.bdd == null ? 0L : (long)this.bdd.getDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalSampler(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }

    @Override
    protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.bdd == null) {
            throw new AggregationExecutionException("Sampler aggregation must be used with child aggregations.");
        }
        return this.bdd.getLeafCollector(ctx);
    }

    @Override
    protected void doClose() {
        Releasables.close(this.bdd);
        super.doClose();
    }

    public static class DiversifiedFactory
    extends ValuesSourceAggregatorFactory<ValuesSource> {
        private int shardSize;
        private int maxDocsPerValue;
        private String executionHint;

        public DiversifiedFactory(String name, int shardSize, String executionHint, ValuesSourceConfig vsConfig, int maxDocsPerValue) {
            super(name, InternalSampler.TYPE.name(), vsConfig);
            this.shardSize = shardSize;
            this.maxDocsPerValue = maxDocsPerValue;
            this.executionHint = executionHint;
        }

        @Override
        protected Aggregator doCreateInternal(ValuesSource valuesSource, AggregationContext context, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            if (valuesSource instanceof ValuesSource.Numeric) {
                return new DiversifiedNumericSamplerAggregator(this.name, this.shardSize, this.factories, context, parent, pipelineAggregators, metaData, (ValuesSource.Numeric)valuesSource, this.maxDocsPerValue);
            }
            if (valuesSource instanceof ValuesSource.Bytes) {
                ExecutionMode execution = null;
                if (this.executionHint != null) {
                    execution = ExecutionMode.fromString(this.executionHint, context.searchContext().parseFieldMatcher());
                }
                if (execution == null) {
                    execution = ExecutionMode.GLOBAL_ORDINALS;
                }
                if (execution.needsGlobalOrdinals() && !(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                    execution = ExecutionMode.MAP;
                }
                return execution.create(this.name, this.factories, this.shardSize, this.maxDocsPerValue, valuesSource, context, parent, pipelineAggregators, metaData);
            }
            throw new AggregationExecutionException("Sampler aggregation cannot be applied to field [" + this.config.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            final UnmappedSampler aggregation = new UnmappedSampler(this.name, pipelineAggregators, metaData);
            return new NonCollectingAggregator(this.name, aggregationContext, parent, this.factories, pipelineAggregators, metaData){

                @Override
                public InternalAggregation buildEmptyAggregation() {
                    return aggregation;
                }
            };
        }
    }

    public static class Factory
    extends AggregatorFactory {
        private int shardSize;

        public Factory(String name, int shardSize) {
            super(name, InternalSampler.TYPE.name());
            this.shardSize = shardSize;
        }

        @Override
        public Aggregator createInternal(AggregationContext context, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new SamplerAggregator(this.name, this.shardSize, this.factories, context, parent, pipelineAggregators, metaData);
        }
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSource valuesSource, AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                return new DiversifiedMapSamplerAggregator(name, shardSize, factories, context, parent, pipelineAggregators, metaData, valuesSource, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        BYTES_HASH(new ParseField("bytes_hash", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSource valuesSource, AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                return new DiversifiedBytesHashSamplerAggregator(name, shardSize, factories, context, parent, pipelineAggregators, metaData, valuesSource, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, int shardSize, int maxDocsPerValue, ValuesSource valuesSource, AggregationContext context, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
                return new DiversifiedOrdinalsSamplerAggregator(name, shardSize, factories, context, parent, pipelineAggregators, metaData, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, maxDocsPerValue);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value, ParseFieldMatcher parseFieldMatcher) {
            for (ExecutionMode mode : ExecutionMode.values()) {
                if (!parseFieldMatcher.match(value, mode.parseField)) continue;
                return mode;
            }
            throw new IllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of " + ExecutionMode.values());
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, int var3, int var4, ValuesSource var5, AggregationContext var6, Aggregator var7, List<PipelineAggregator> var8, Map<String, Object> var9) throws IOException;

        abstract boolean needsGlobalOrdinals();

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

