/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gjt.sp.jedit.ActionListHandler;
import org.gjt.sp.jedit.JEditAbstractEditAction;
import org.gjt.sp.jedit.JEditActionContext;
import org.gjt.sp.jedit.JEditBeanShellAction;
import org.gjt.sp.jedit.input.AbstractInputHandler;
import org.gjt.sp.jedit.input.InputHandlerProvider;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;

public abstract class JEditActionSet<E extends JEditAbstractEditAction>
implements InputHandlerProvider {
    JEditActionContext context;
    protected Hashtable<String, Object> actions = new Hashtable();
    protected URL uri;
    protected boolean loaded = true;
    protected static final Object placeholder = new Object();

    protected JEditActionSet() {
    }

    protected JEditActionSet(String[] stringArray, URL uRL) {
        this();
        this.uri = uRL;
        if (stringArray != null) {
            for (String string : stringArray) {
                this.actions.put(string, placeholder);
            }
        }
        this.loaded = false;
    }

    public void addAction(E e) {
        this.actions.put(((JEditAbstractEditAction)e).getName(), e);
        if (this.context != null) {
            this.context.actionNames = null;
            this.context.actionHash.put(((JEditAbstractEditAction)e).getName(), this);
        }
    }

    public void removeAction(String string) {
        this.actions.remove(string);
        if (this.context != null) {
            this.context.actionNames = null;
            this.context.actionHash.remove(string);
        }
    }

    public void removeAllActions() {
        if (this.context != null) {
            String[] stringArray;
            this.context.actionNames = null;
            for (String string : stringArray = this.getActionNames()) {
                this.context.actionHash.remove(string);
            }
        }
        this.actions.clear();
    }

    public E getAction(String string) {
        Object object = this.actions.get(string);
        if (object == placeholder) {
            this.load();
            object = this.actions.get(string);
            if (object == placeholder) {
                Log.log(7, this, "Outdated cache");
                object = null;
            }
        }
        return (E)((JEditAbstractEditAction)object);
    }

    public int getActionCount() {
        return this.actions.size();
    }

    public String[] getActionNames() {
        String[] stringArray = new String[this.actions.size()];
        Set<String> set = this.actions.keySet();
        int n = 0;
        for (String string : set) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public String[] getCacheableActionNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Object object : this.actions.values()) {
            if (object == placeholder) {
                Log.log(7, this, "Action set not up to date");
                continue;
            }
            if (!(object instanceof JEditBeanShellAction)) continue;
            linkedList.add(((JEditBeanShellAction)object).getName());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    protected abstract E[] getArray(int var1);

    public E[] getActions() {
        this.load();
        JEditAbstractEditAction[] jEditAbstractEditActionArray = this.getArray(this.actions.size());
        Collection<Object> collection = this.actions.values();
        int n = 0;
        for (Object object : collection) {
            jEditAbstractEditActionArray[n++] = (JEditAbstractEditAction)object;
        }
        return jEditAbstractEditActionArray;
    }

    public boolean contains(String string) {
        boolean bl = this.actions.containsKey(string);
        return bl;
    }

    public int size() {
        return this.actions.size();
    }

    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (this.uri == null) {
            return;
        }
        try {
            InputStream inputStream;
            Log.log(1, this, "Loading actions from " + this.uri);
            ActionListHandler actionListHandler = new ActionListHandler(this.uri.toString(), this);
            try {
                inputStream = this.uri.openStream();
            }
            catch (FileNotFoundException fileNotFoundException) {
                inputStream = null;
                Log.log(7, this, "Unable to open: " + this.uri);
            }
            if (inputStream != null && XMLUtilities.parseXML(inputStream, actionListHandler)) {
                Log.log(9, this, "Unable to parse: " + this.uri);
            }
        }
        catch (IOException iOException) {
            Log.log(9, this, this.uri, iOException);
        }
    }

    protected abstract JEditAbstractEditAction createBeanShellAction(String var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    public void initKeyBindings() {
        AbstractInputHandler abstractInputHandler = this.getInputHandler();
        Set<Map.Entry<String, Object>> set = this.actions.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            String string;
            String string2 = entry.getKey();
            String string3 = this.getProperty(string2 + ".shortcut");
            if (string3 != null) {
                abstractInputHandler.addKeyBinding(string3, string2);
            }
            if ((string = this.getProperty(string2 + ".shortcut2")) == null) continue;
            abstractInputHandler.addKeyBinding(string, string2);
        }
    }

    protected abstract String getProperty(String var1);

    void getActionNames(List<String> list) {
        list.addAll(this.actions.keySet());
    }
}

