/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import java.util.AbstractList;
import java.util.List;

final class TruffleList<T>
extends AbstractList<T> {
    private final TruffleObject array;
    private final Class<T> type;

    private TruffleList(Class<T> elementType, TruffleObject array) {
        this.array = array;
        this.type = elementType;
    }

    public static <T> List<T> create(Class<T> elementType, TruffleObject array) {
        return new TruffleList<T>(elementType, array);
    }

    @Override
    public T get(int index) {
        return this.type.cast(JavaInterop.message(Message.READ, this.array, index));
    }

    @Override
    public T set(int index, T element) {
        T prev = this.get(index);
        JavaInterop.message(Message.WRITE, this.array, index, element);
        return prev;
    }

    @Override
    public int size() {
        return (Integer)JavaInterop.message(Message.GET_SIZE, this.array, new Object[0]);
    }
}

