/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;

public final class SourceSection {
    private final Source source;
    private final String identifier;
    private final int startLine;
    private final int startColumn;
    private final int charIndex;
    private final int charLength;
    private final String kind;

    SourceSection(String kind, Source source, String identifier, int startLine, int startColumn, int charIndex, int charLength) {
        this.kind = kind;
        this.source = source;
        this.identifier = identifier;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.charIndex = charIndex;
        this.charLength = charLength;
    }

    public Source getSource() {
        return this.source;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public LineLocation getLineLocation() {
        return this.source.createLineLocation(this.startLine);
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.source.getLineNumber(this.charIndex + this.charLength - 1);
    }

    public int getEndColumn() {
        return this.source.getColumnNumber(this.charIndex + this.charLength - 1);
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public int getCharLength() {
        return this.charLength;
    }

    public int getCharEndIndex() {
        return this.charIndex + this.charLength;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getCode() {
        return this.source == null ? "<unavailable>" : this.source.getCode(this.charIndex, this.charLength);
    }

    public String getShortDescription() {
        if (this.source == null) {
            return this.kind + ": " + this.identifier;
        }
        return String.format("%s:%d", this.source.getShortName(), this.startLine);
    }

    public String toString() {
        if (this.source == null) {
            return this.kind + ": " + this.identifier;
        }
        return "source=" + this.source.getShortName() + " pos=" + this.charIndex + " len=" + this.charLength + " line=" + this.startLine + " col=" + this.startColumn + (this.identifier != null ? " identifier=" + this.identifier : "") + " code=" + this.getCode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.charIndex;
        result = 31 * result + this.charLength;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + this.startColumn;
        result = 31 * result + this.startLine;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceSection)) {
            return false;
        }
        SourceSection other = (SourceSection)obj;
        if (this.charIndex != other.charIndex) {
            return false;
        }
        if (this.charLength != other.charLength) {
            return false;
        }
        if (this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.startColumn != other.startColumn) {
            return false;
        }
        return this.startLine == other.startLine;
    }

    public static SourceSection createUnavailable(String kind, String name) {
        return new SourceSection(kind, null, name == null ? "<unknown>" : name, -1, -1, -1, -1);
    }
}

