/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.dispatch;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.cast.ProcOrNullNode;
import org.jruby.truffle.nodes.cast.ProcOrNullNodeGen;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class RubyCallNode
extends RubyNode {
    private final String methodName;
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private ProcOrNullNode block;
    @Node.Children
    private final RubyNode[] arguments;
    private final boolean isSplatted;
    private final boolean isVCall;
    @Node.Child
    private CallDispatchHeadNode dispatchHead;
    @CompilerDirectives.CompilationFinal
    private boolean seenNullInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenIntegerFixnumInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenLongFixnumInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenFloatInUnsplat = false;
    @CompilerDirectives.CompilationFinal
    private boolean seenObjectInUnsplat = false;
    @Node.Child
    private CallDispatchHeadNode respondToMissing;
    @Node.Child
    private BooleanCastNode respondToMissingCast;
    private final boolean ignoreVisibility;

    public RubyCallNode(RubyContext context, SourceSection section, String methodName, RubyNode receiver, RubyNode block, boolean isSplatted, RubyNode ... arguments) {
        this(context, section, methodName, receiver, block, isSplatted, false, arguments);
    }

    public RubyCallNode(RubyContext context, SourceSection section, String methodName, RubyNode receiver, RubyNode block, boolean isSplatted, boolean ignoreVisibility, RubyNode ... arguments) {
        this(context, section, methodName, receiver, block, isSplatted, ignoreVisibility, false, arguments);
    }

    public RubyCallNode(RubyContext context, SourceSection section, String methodName, RubyNode receiver, RubyNode block, boolean isSplatted, boolean ignoreVisibility, boolean isVCall, RubyNode ... arguments) {
        super(context, section);
        this.methodName = methodName;
        this.receiver = receiver;
        this.arguments = arguments;
        this.block = block == null ? null : ProcOrNullNodeGen.create(context, section, block);
        this.isSplatted = isSplatted;
        this.isVCall = isVCall;
        this.ignoreVisibility = ignoreVisibility;
        this.dispatchHead = DispatchHeadNodeFactory.createMethodCall(context, ignoreVisibility);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object receiverObject = this.receiver.execute(frame);
        Object[] argumentsObjects = this.executeArguments(frame);
        DynamicObject blockObject = this.executeBlock(frame);
        return this.dispatchHead.call(frame, receiverObject, this.methodName, blockObject, argumentsObjects);
    }

    private DynamicObject executeBlock(VirtualFrame frame) {
        if (this.block != null) {
            return (DynamicObject)this.block.execute(frame);
        }
        return null;
    }

    @ExplodeLoop
    private Object[] executeArguments(VirtualFrame frame) {
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        if (this.isSplatted) {
            return this.splat(argumentsObjects[0]);
        }
        return argumentsObjects;
    }

    private Object[] splat(Object argument) {
        if (!RubyGuards.isRubyArray(argument)) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException(argument.getClass().toString());
        }
        DynamicObject array = (DynamicObject)argument;
        int size = Layouts.ARRAY.getSize(array);
        Object store = Layouts.ARRAY.getStore(array);
        if (this.seenNullInUnsplat && store == null) {
            return new Object[0];
        }
        if (this.seenIntegerFixnumInUnsplat && store instanceof int[]) {
            return ArrayUtils.boxUntil((int[])store, size);
        }
        if (this.seenLongFixnumInUnsplat && store instanceof long[]) {
            return ArrayUtils.boxUntil((long[])store, size);
        }
        if (this.seenFloatInUnsplat && store instanceof double[]) {
            return ArrayUtils.boxUntil((double[])store, size);
        }
        if (this.seenObjectInUnsplat && store != null && store.getClass() == Object[].class) {
            return ArrayUtils.extractRange((Object[])store, 0, size);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        if (store == null) {
            this.seenNullInUnsplat = true;
            return new Object[0];
        }
        if (store instanceof int[]) {
            this.seenIntegerFixnumInUnsplat = true;
            return ArrayUtils.boxUntil((int[])store, size);
        }
        if (store instanceof long[]) {
            this.seenLongFixnumInUnsplat = true;
            return ArrayUtils.boxUntil((long[])store, size);
        }
        if (store instanceof double[]) {
            this.seenFloatInUnsplat = true;
            return ArrayUtils.boxUntil((double[])store, size);
        }
        if (store.getClass() == Object[].class) {
            this.seenObjectInUnsplat = true;
            return ArrayUtils.extractRange((Object[])store, 0, size);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object receiverObject;
        CompilerDirectives.transferToInterpreter();
        if (this.receiver.isDefined(frame) == this.nil()) {
            return this.nil();
        }
        for (RubyNode argument : this.arguments) {
            if (argument.isDefined(frame) != this.nil()) continue;
            return this.nil();
        }
        RubyContext context = this.getContext();
        try {
            CompilerAsserts.neverPartOfCompilation();
            receiverObject = this.receiver.execute(frame);
        }
        catch (Exception e) {
            return this.nil();
        }
        InternalMethod method = ModuleOperations.lookupMethod(context.getCoreLibrary().getMetaClass(receiverObject), this.methodName);
        Object self = RubyArguments.getSelf(frame.getArguments());
        if (method == null) {
            Object r = this.respondToMissing(frame, receiverObject);
            if (r != DispatchNode.MISSING && !this.castRespondToMissingToBoolean(frame, r)) {
                return this.nil();
            }
        } else {
            if (method.isUndefined()) {
                return this.nil();
            }
            if (!this.ignoreVisibility && !method.isVisibleTo(this, context.getCoreLibrary().getMetaClass(self))) {
                return this.nil();
            }
        }
        return this.create7BitString(StringOperations.encodeByteList("method", (Encoding)UTF8Encoding.INSTANCE));
    }

    private Object respondToMissing(VirtualFrame frame, Object receiverObject) {
        if (this.respondToMissing == null) {
            CompilerDirectives.transferToInterpreter();
            this.respondToMissing = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true, MissingBehavior.RETURN_MISSING));
        }
        DynamicObject method = this.getContext().getSymbol(this.methodName);
        return this.respondToMissing.call(frame, receiverObject, "respond_to_missing?", null, method, false);
    }

    private boolean castRespondToMissingToBoolean(VirtualFrame frame, Object r) {
        if (this.respondToMissingCast == null) {
            CompilerDirectives.transferToInterpreter();
            this.respondToMissingCast = this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        return this.respondToMissingCast.executeBoolean(frame, r);
    }

    public String getName() {
        return this.methodName;
    }

    public boolean isVCall() {
        return this.isVCall;
    }
}

