/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.instrument;

import com.oracle.truffle.api.instrument.ASTProber;
import com.oracle.truffle.api.instrument.Instrumenter;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.StandardSyntaxTag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.nodes.RootNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.objects.OpenModuleNode;
import org.jruby.truffle.runtime.RubyLanguage;
import org.jruby.truffle.runtime.RubySyntaxTag;

public class RubyDefaultASTProber
implements NodeVisitor,
ASTProber {
    private final Instrumenter instrumenter;

    public RubyDefaultASTProber(Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }

    @Override
    public boolean visit(Node node) {
        if (RubyLanguage.INSTANCE.isInstrumentable(node) && node instanceof RubyNode) {
            Probe probe;
            RubyNode rubyNode = (RubyNode)node;
            if (rubyNode.isAtNewline()) {
                probe = this.instrumenter.probe(rubyNode);
                probe.tagAs(StandardSyntaxTag.STATEMENT, null);
                probe.tagAs(RubySyntaxTag.LINE, null);
            }
            if (rubyNode instanceof OpenModuleNode) {
                probe = this.instrumenter.probe(rubyNode);
                probe.tagAs(RubySyntaxTag.CLASS, null);
            } else if (rubyNode.getParent() instanceof RubyRootNode) {
                probe = this.instrumenter.probe(rubyNode);
                probe.tagAs(RubySyntaxTag.CALL, null);
            }
        }
        return true;
    }

    @Override
    public void probeAST(Instrumenter instrumenter, RootNode rootNode) {
        rootNode.accept(this);
    }
}

