/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class WriteInstanceVariableNode
extends RubyNode {
    @Node.Child
    private RubyNode receiver;
    @Node.Child
    private RubyNode rhs;
    @Node.Child
    private WriteHeadObjectFieldNode writeNode;

    public WriteInstanceVariableNode(RubyContext context, SourceSection sourceSection, String name, RubyNode receiver, RubyNode rhs) {
        super(context, sourceSection);
        this.receiver = receiver;
        this.rhs = rhs;
        this.writeNode = WriteHeadObjectFieldNodeGen.create(name);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object object = this.receiver.execute(frame);
        Object value = this.rhs.execute(frame);
        if (!(object instanceof DynamicObject)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(Layouts.MODULE.getFields(this.getContext().getCoreLibrary().getLogicalClass(object)).getName(), this));
        }
        this.writeNode.execute((DynamicObject)object, value);
        return value;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        return this.create7BitString(StringOperations.encodeByteList("assignment", (Encoding)UTF8Encoding.INSTANCE));
    }
}

