/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.ob.impl.CollectionBuilder;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionReader
extends ValueReader {
    protected final Class<?> _collectionType;
    protected final ValueReader _valueReader;

    public CollectionReader(Class<?> clazz, ValueReader valueReader) {
        this._collectionType = clazz == Collection.class || clazz == List.class ? null : (clazz == Set.class ? HashSet.class : (clazz == SortedSet.class ? TreeSet.class : clazz));
        this._valueReader = valueReader;
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        CollectionBuilder collectionBuilder = jSONReader._collectionBuilder(this._collectionType);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyCollection();
        }
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonCollection(object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildCollection();
    }
}

