/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.dashboard.preference;

import javafx.scene.control.CheckBox;
import org.pdfsam.context.BooleanUserPreference;
import org.pdfsam.context.UserContext;
import org.pdfsam.support.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreferenceCheckBox
extends CheckBox {
    private static final Logger LOG = LoggerFactory.getLogger(PreferenceCheckBox.class);
    private final BooleanUserPreference preference;

    PreferenceCheckBox(BooleanUserPreference preference, String label, boolean selected, UserContext userContext) {
        super(label);
        RequireUtils.requireNotNull((Object)preference, "Preference cannot be null");
        RequireUtils.requireNotNull(userContext, "UserContext cannot be null");
        this.setSelected(selected);
        this.preference = preference;
        this.selectedProperty().addListener((ov, oldVal, newVal) -> {
            userContext.setBooleanPreference(this.preference, (boolean)newVal);
            LOG.trace("Preference {} set to {}", (Object)this.preference, newVal);
        });
    }
}

