/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.workarea;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.module.Module;
import org.pdfsam.ui.event.SetActiveModuleRequest;
import org.pdfsam.ui.event.SetTitleEvent;
import org.pdfsam.ui.quickbar.QuickbarPane;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workarea.QuickbarModuleButtonsPane;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;

@Named
public class WorkArea
extends BorderPane {
    private Map<String, Module> modules = new HashMap<String, Module>();
    private Optional<Module> current = Optional.empty();
    private StackPane center = new StackPane();
    private FadeTransition fade = new FadeTransition(new Duration(300.0), (Node)this.center);

    @Inject
    public WorkArea(List<Module> modulesList) {
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.setId("work-area");
        for (Module module : modulesList) {
            this.modules.put(module.id(), module);
        }
        this.fade.setFromValue(0.0);
        this.fade.setToValue(1.0);
        this.setCenter((Node)this.center);
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @Inject
    void setModulesPane(QuickbarModuleButtonsPane modulesButtons) {
        this.setLeft((Node)new QuickbarPane(modulesButtons));
    }

    @EventListener
    public void onSetActiveModule(SetActiveModuleRequest request) {
        request.getActiveModuleId().ifPresent(id -> {
            Module requested = this.modules.get(id);
            if (requested != null) {
                this.current = Optional.of(requested);
                this.center.getChildren().setAll((Object[])new Node[]{requested.modulePanel()});
                this.fade.play();
            }
        });
        StaticStudio.eventStudio().broadcast(new SetTitleEvent(this.current.map(m -> m.descriptor().getName()).orElse("")));
    }
}

