/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.stream.Collectors;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.util.EncryptionUtils;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.EncryptParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.encryption.StandardSecurity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptTask
extends BaseTask<EncryptParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptTask.class);
    private int totalSteps;
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private StandardSecurity security;

    @Override
    public void before(EncryptParameters parameters) {
        this.totalSteps = parameters.getSourceList().size();
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy());
        this.security = EncryptionUtils.securityFromParams(parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(EncryptParameters parameters) throws TaskException {
        int currentStep = 0;
        for (PdfSource source : parameters.getSourceList()) {
            this.stopTaskIfCancelled();
            ++currentStep;
            LOG.debug("Opening {}", (Object)source);
            try {
                this.documentHandler = source.open(this.documentLoader);
                this.documentHandler.setCreatorOnPDDocument();
                File tmpFile = IOUtils.createTemporaryPdfBuffer();
                LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
                this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
                this.documentHandler.setCompress(parameters.isCompress());
                this.documentHandler.savePDDocument(tmpFile, this.security);
                String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest().originalName(source.getName()).fileNumber(currentStep));
                this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            }
            finally {
                ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
            }
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(currentStep).outOf(this.totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Input documents encrypted using {}, standard security handler revision {} and written to {}", new Object[]{this.security.encryption, this.security.encryption.revision.revisionNumber, parameters.getOutput()});
        LOG.debug("Permissions: {}", (Object)parameters.getPermissions().stream().map(PdfAccessPermission::getFriendlyName).collect(Collectors.joining(", ")));
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
    }
}

