/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Set;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.core.writer.context.ImageWriterContext;
import org.sejda.core.writer.model.ImageWriter;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.image.PdfToJpegParameters;
import org.sejda.model.task.BaseTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfToMultipleImageTask
extends BaseTask<PdfToJpegParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(PdfToMultipleImageTask.class);
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> sourceOpener = new DefaultPdfSourceOpener();
    private PDDocumentHandler documentHandler = null;
    private ImageWriter<PdfToJpegParameters> writer;

    @Override
    public void before(PdfToJpegParameters parameters) throws TaskException {
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy());
        this.writer = ImageWriterContext.getContext().getImageWriterFactory().createImageWriter(parameters);
        if (this.writer == null) {
            LOG.info("Unable to create an ImageWriter using the provided factory, falling back on default factory.");
            this.writer = ImageWriterContext.getContext().getDefaultImageWriterFactory().createImageWriter(parameters);
        }
        if (this.writer == null) {
            throw new TaskExecutionException(String.format("No suitable ImageWriter found for %s.", parameters));
        }
        LOG.trace("Found image writer {}", (Object)this.writer);
    }

    @Override
    public void execute(PdfToJpegParameters parameters) throws TaskException {
        this.documentHandler = parameters.getSource().open(this.sourceOpener);
        Set<Integer> requestedPages = parameters.getPages(this.documentHandler.getNumberOfPages());
        if (requestedPages == null || requestedPages.isEmpty()) {
            throw new TaskExecutionException("No page has been selected for conversion.");
        }
        int currentStep = 0;
        int totalSteps = requestedPages.size();
        LOG.trace("Found {} pages to convert", (Object)totalSteps);
        for (int currentPage : requestedPages) {
            ++currentStep;
            File tmpFile = IOUtils.createTemporaryBuffer();
            LOG.debug("Created output temporary buffer {} ", (Object)tmpFile);
            LOG.trace("Writing page {}", (Object)currentPage);
            BufferedImage pageImage = this.documentHandler.renderImage(currentPage, parameters.getResolutionInDpi());
            this.writer.openWriteDestination(tmpFile, parameters);
            LOG.trace("Writing page {}", (Object)currentPage);
            this.writer.write(pageImage, parameters);
            this.writer.closeDestination();
            String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest(parameters.getOutputImageType().getExtension()).page(currentPage).originalName(parameters.getSource().getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(currentStep).outOf(totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Document converted to {} and saved to {}", (Object)parameters.getOutputImageType(), (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
        ComponentsUtility.nullSafeCloseQuietly(this.writer);
    }
}

