/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Rectangle;
import java.io.IOException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.text.PDFTextStripperByArea;

public class PdfTextExtractorByArea {
    private static final int GUESSTIMATE_HEADER_FOOTER_HEIGHT = 50;

    public String extractFooterText(PDPage page) throws TaskIOException {
        return this.extractTextFromArea(page, this.getFooterAreaRectangle(page));
    }

    public String extractHeaderText(PDPage page) throws TaskIOException {
        return this.extractTextFromArea(page, this.getHeaderAreaRectangle(page));
    }

    private Rectangle getFooterAreaRectangle(PDPage page) {
        PDRectangle pageSize = page.getCropBox();
        int pageHeight = (int)pageSize.getHeight();
        int pageWidth = (int)pageSize.getWidth();
        return new Rectangle(0, pageHeight - 50, pageWidth, 50);
    }

    private Rectangle getHeaderAreaRectangle(PDPage page) {
        PDRectangle pageSize = page.getCropBox();
        int pageWidth = (int)pageSize.getWidth();
        return new Rectangle(0, 0, pageWidth, 50);
    }

    public String extractTextFromArea(PDPage page, Rectangle area) throws TaskIOException {
        try {
            PDFTextStripperByArea stripper = new PDFTextStripperByArea();
            stripper.setSortByPosition(true);
            stripper.addRegion("area1", area);
            stripper.extractRegions(page);
            return stripper.getTextForRegion("area1");
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred extracting text from page.", e);
        }
    }
}

