/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimizaton;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sejda.model.optimization.OptimizationPolicy;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimizationRuler
implements Function<PDDocument, Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizationRuler.class);
    private OptimizationPolicy policy;

    public OptimizationRuler(OptimizationPolicy policy) {
        RequireUtils.requireNotNullArg(policy, "Optimization policy cannot be null");
        this.policy = policy;
    }

    @Override
    public Boolean apply(PDDocument document) {
        if (this.policy == OptimizationPolicy.YES) {
            return true;
        }
        if (this.policy == OptimizationPolicy.AUTO) {
            return this.willNeedOptimization(document);
        }
        return false;
    }

    private boolean willNeedOptimization(PDDocument document) {
        return this.hasSharedXObjectDictionaries(document) || this.hasInheritedImages(document);
    }

    private boolean hasInheritedImages(PDDocument document) {
        long inheritedImage = document.getPages().streamNodes().filter(PDPageTree::isPageTreeNode).map(d -> d.getDictionaryObject(COSName.RESOURCES)).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d).map(d -> d.getDictionaryObject(COSName.XOBJECT)).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d).flatMap(d -> d.getValues().stream()).map(COSBase::getCOSObject).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d).map(d -> d.getNameAsString(COSName.SUBTYPE)).filter(Objects::nonNull).filter(COSName.IMAGE.getName()::equals).count();
        LOG.debug("Found {} inherited images potentially unused", (Object)inheritedImage);
        return inheritedImage > 0L;
    }

    private boolean hasSharedXObjectDictionaries(PDDocument document) {
        List xobjectsDictionaries = document.getPages().stream().map(PDPage::getCOSObject).filter(Objects::nonNull).map(d -> d.getDictionaryObject(COSName.RESOURCES)).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d).map(d -> d.getDictionaryObject(COSName.XOBJECT)).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d).filter(x -> x.getValues().stream().map(COSBase::getCOSObject).filter(v -> v instanceof COSDictionary).map(v -> (COSDictionary)v).map(v -> v.getNameAsString(COSName.SUBTYPE)).filter(Objects::nonNull).filter(COSName.IMAGE.getName()::equals).count() > 0L).collect(Collectors.toList());
        long distinctXobjectsDictionaries = xobjectsDictionaries.stream().distinct().count();
        if ((long)xobjectsDictionaries.size() > distinctXobjectsDictionaries) {
            LOG.debug("Found shared XObject dictionary containing image resouces");
            return true;
        }
        return false;
    }
}

