/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimizaton;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sejda.impl.sambox.component.ReadOnlyFilteredCOSStream;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDictionaryCleaner
implements Consumer<PDDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDictionaryCleaner.class);

    @Override
    public void accept(PDDocument p) {
        LOG.debug("Cleaning resource dictionaries from unused external objects");
        this.clean(p.getPages().streamNodes());
    }

    public void clean(PDPage page) {
        this.clean(Stream.of(page.getCOSObject()));
    }

    private void clean(Stream<COSDictionary> nodes) {
        Stream<COSDictionary> xobjects = nodes.map(d -> d.getDictionaryObject(COSName.RESOURCES)).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d).map(d -> d.getDictionaryObject(COSName.XOBJECT)).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d);
        xobjects.forEach(x -> {
            Set toRemove = x.entrySet().stream().filter(e -> !(((COSBase)e.getValue()).getCOSObject() instanceof ReadOnlyFilteredCOSStream)).filter(e -> ((COSBase)e.getValue()).getCOSObject() instanceof COSStream).filter(e -> ((COSStream)((COSBase)e.getValue()).getCOSObject()).getItem(COSName.SUBTYPE).equals(COSName.IMAGE)).map(e -> (COSName)e.getKey()).collect(Collectors.toSet());
            LOG.trace("Removing {} xobjects from {}", (Object)toRemove.size(), x);
            toRemove.stream().forEach(x::removeItem);
        });
    }
}

