/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.sejda.io.BufferedSeekableSource;
import org.sejda.io.ByteArraySeekableSource;
import org.sejda.io.FileChannelSeekableSource;
import org.sejda.io.MemoryMappedSeekableSource;
import org.sejda.io.SeekableSource;

public final class SeekableSources {
    public static final String MAPPED_SIZE_THRESHOLD_PROPERTY = "org.sejda.io.mapped.size.threshold";
    public static final String DISABLE_MEMORY_MAPPED_PROPERTY = "org.sejda.io.mapped.disabled";
    public static final String INPUT_BUFFER_SIZE_PROPERTY = "org.sejda.io.buffered.input.size";
    public static final String MEMORY_MAPPED_PAGE_SIZE_PROPERTY = "org.sejda.io.memory.mapped.page.size";
    private static final long MB_16 = 0x1000000L;

    private SeekableSources() {
    }

    public static SeekableSource seekableSourceFrom(File file) throws IOException {
        Objects.requireNonNull(file);
        if (!Boolean.getBoolean(DISABLE_MEMORY_MAPPED_PROPERTY) && file.length() > Long.getLong(MAPPED_SIZE_THRESHOLD_PROPERTY, 0x1000000L)) {
            return new BufferedSeekableSource(new MemoryMappedSeekableSource(file));
        }
        return new BufferedSeekableSource(new FileChannelSeekableSource(file));
    }

    public static SeekableSource inMemorySeekableSourceFrom(InputStream stream) throws IOException {
        Objects.requireNonNull(stream);
        return new ByteArraySeekableSource(IOUtils.toByteArray(stream));
    }

    public static SeekableSource inMemorySeekableSourceFrom(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new ByteArraySeekableSource(bytes);
    }

    public static SeekableSource onTempFileSeekableSourceFrom(InputStream stream) throws IOException {
        Objects.requireNonNull(stream);
        final Path temp = Files.createTempFile("SejdaIO", null, new FileAttribute[0]);
        Files.copy(stream, temp, StandardCopyOption.REPLACE_EXISTING);
        return new BufferedSeekableSource(new FileChannelSeekableSource(temp.toFile()){

            @Override
            public void close() throws IOException {
                super.close();
                Files.deleteIfExists(temp);
            }
        });
    }
}

