/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.security.MessageDigest;
import org.bouncycastle.util.Arrays;
import org.sejda.sambox.encryption.ARC4Engine;
import org.sejda.sambox.encryption.EncryptUtils;
import org.sejda.sambox.encryption.EncryptionContext;
import org.sejda.sambox.encryption.MessageDigests;
import org.sejda.sambox.encryption.PasswordAlgorithm;
import org.sejda.sambox.encryption.StandardSecurityHandlerRevision;

class Algorithm5
implements PasswordAlgorithm {
    private MessageDigest digest = MessageDigests.md5();
    private ARC4Engine engine = new ARC4Engine();

    Algorithm5() {
    }

    @Override
    public byte[] computePassword(EncryptionContext context) {
        context.security.encryption.revision.requireAtLeast(StandardSecurityHandlerRevision.R3, "Algorithm 5 requires a security handler of revision 3 or greater");
        this.digest.reset();
        this.digest.update(EncryptUtils.ENCRYPT_PADDING);
        byte[] encrypted = this.engine.encryptBytes(Arrays.copyOf(this.digest.digest(context.documentId()), 16), context.key());
        byte[] iterationKey = new byte[context.key().length];
        for (int i = 1; i < 20; ++i) {
            iterationKey = Arrays.copyOf(context.key(), context.key().length);
            for (int j = 0; j < iterationKey.length; ++j) {
                iterationKey[j] = (byte)(iterationKey[j] ^ (byte)i);
            }
            encrypted = this.engine.encryptBytes(encrypted, iterationKey);
        }
        return Arrays.concatenate(Arrays.copyOf(encrypted, 16), Arrays.copyOf(EncryptUtils.ENCRYPT_PADDING, 16));
    }
}

