/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.MissingImageReaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Filter {
    private static final Logger LOG = LoggerFactory.getLogger(Filter.class);

    protected Filter() {
    }

    public abstract DecodeResult decode(InputStream var1, OutputStream var2, COSDictionary var3, int var4) throws IOException;

    public abstract void encode(InputStream var1, OutputStream var2, COSDictionary var3) throws IOException;

    protected COSDictionary getDecodeParams(COSDictionary dictionary, int index) {
        COSArray array;
        COSBase obj = Optional.ofNullable(dictionary.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP)).orElseGet(COSDictionary::new);
        if (obj instanceof COSDictionary) {
            return (COSDictionary)obj;
        }
        if (obj instanceof COSArray && index < (array = (COSArray)obj).size()) {
            COSBase params = Optional.ofNullable(array.getObject(index)).orElseGet(COSDictionary::new);
            if (params instanceof COSDictionary) {
                return (COSDictionary)params;
            }
            LOG.error("Ignoring invalid DecodeParams. Expected dictionary but found {}", (Object)params.getClass().getName());
            return new COSDictionary();
        }
        LOG.error("Ignoring invalid DecodeParams. Expected array or dictionary but found {}", (Object)obj.getClass().getName());
        return new COSDictionary();
    }

    protected static ImageReader findImageReader(String formatName, String errorCause) throws MissingImageReaderException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(formatName);
        ImageReader reader = null;
        while (readers.hasNext() && !(reader = readers.next()).canReadRaster()) {
        }
        if (reader == null) {
            throw new MissingImageReaderException("Cannot read " + formatName + " image: " + errorCause);
        }
        return reader;
    }
}

