/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sejda.sambox.cos.COSObjectKey;
import org.sejda.sambox.pdmodel.ResourceCache;
import org.sejda.sambox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.sejda.sambox.pdmodel.font.PDFont;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.color.PDColorSpace;
import org.sejda.sambox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.sejda.sambox.pdmodel.graphics.shading.PDShading;
import org.sejda.sambox.pdmodel.graphics.state.PDExtendedGraphicsState;

public class DefaultResourceCache
implements ResourceCache {
    private final Map<COSObjectKey, SoftReference<PDFont>> fonts = new HashMap<COSObjectKey, SoftReference<PDFont>>();
    private final Map<COSObjectKey, SoftReference<PDColorSpace>> colorSpaces = new HashMap<COSObjectKey, SoftReference<PDColorSpace>>();
    private final Map<COSObjectKey, SoftReference<PDXObject>> xobjects = new HashMap<COSObjectKey, SoftReference<PDXObject>>();
    private final Map<COSObjectKey, SoftReference<PDExtendedGraphicsState>> extGStates = new HashMap<COSObjectKey, SoftReference<PDExtendedGraphicsState>>();
    private final Map<COSObjectKey, SoftReference<PDShading>> shadings = new HashMap<COSObjectKey, SoftReference<PDShading>>();
    private final Map<COSObjectKey, SoftReference<PDAbstractPattern>> patterns = new HashMap<COSObjectKey, SoftReference<PDAbstractPattern>>();
    private final Map<COSObjectKey, SoftReference<PDPropertyList>> properties = new HashMap<COSObjectKey, SoftReference<PDPropertyList>>();

    @Override
    public PDFont getFont(COSObjectKey key) {
        return Optional.ofNullable(this.fonts.get(key)).map(SoftReference::get).orElse(null);
    }

    @Override
    public void put(COSObjectKey key, PDFont font) {
        this.fonts.put(key, new SoftReference<PDFont>(font));
    }

    @Override
    public PDColorSpace getColorSpace(COSObjectKey key) {
        return Optional.ofNullable(this.colorSpaces.get(key)).map(SoftReference::get).orElse(null);
    }

    @Override
    public void put(COSObjectKey key, PDColorSpace colorSpace) {
        this.colorSpaces.put(key, new SoftReference<PDColorSpace>(colorSpace));
    }

    @Override
    public PDExtendedGraphicsState getExtGState(COSObjectKey key) {
        return Optional.ofNullable(this.extGStates.get(key)).map(SoftReference::get).orElse(null);
    }

    @Override
    public void put(COSObjectKey key, PDExtendedGraphicsState extGState) {
        this.extGStates.put(key, new SoftReference<PDExtendedGraphicsState>(extGState));
    }

    @Override
    public PDShading getShading(COSObjectKey key) {
        return Optional.ofNullable(this.shadings.get(key)).map(SoftReference::get).orElse(null);
    }

    @Override
    public void put(COSObjectKey key, PDShading shading) {
        this.shadings.put(key, new SoftReference<PDShading>(shading));
    }

    @Override
    public PDAbstractPattern getPattern(COSObjectKey key) {
        return Optional.ofNullable(this.patterns.get(key)).map(SoftReference::get).orElse(null);
    }

    @Override
    public void put(COSObjectKey key, PDAbstractPattern pattern) {
        this.patterns.put(key, new SoftReference<PDAbstractPattern>(pattern));
    }

    @Override
    public PDPropertyList getProperties(COSObjectKey key) {
        return Optional.ofNullable(this.properties.get(key)).map(SoftReference::get).orElse(null);
    }

    @Override
    public void put(COSObjectKey key, PDPropertyList propertyList) {
        this.properties.put(key, new SoftReference<PDPropertyList>(propertyList));
    }

    @Override
    public PDXObject getXObject(COSObjectKey key) {
        return Optional.ofNullable(this.xobjects.get(key)).map(SoftReference::get).orElse(null);
    }

    @Override
    public void put(COSObjectKey key, PDXObject xobject) {
        this.xobjects.put(key, new SoftReference<PDXObject>(xobject));
    }

    @Override
    public void clear() {
        this.fonts.clear();
        this.colorSpaces.clear();
        this.extGStates.clear();
        this.patterns.clear();
        this.properties.clear();
        this.shadings.clear();
        this.xobjects.clear();
    }
}

