/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control;

import com.baselet.control.CanCloseProgram;
import com.baselet.control.config.Config;
import com.baselet.control.config.handler.ConfigHandler;
import com.baselet.control.constants.Constants;
import com.baselet.control.enums.Program;
import com.baselet.control.util.CanOpenDiagram;
import com.baselet.control.util.Path;
import com.baselet.control.util.RecentlyUsedFilesList;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.Notifier;
import com.baselet.diagram.PaletteHandler;
import com.baselet.diagram.io.OpenFileChooser;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.BaseGUI;
import com.baselet.gui.CurrentGui;
import com.baselet.gui.pane.OwnSyntaxPane;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements CanCloseProgram,
CanOpenDiagram {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static Main main = new Main();
    private GridElement editedGridElement;
    private TreeMap<String, PaletteHandler> palettes;
    private final ArrayList<DiagramHandler> diagrams = new ArrayList();

    public static Main getInstance() {
        return main;
    }

    public void init(BaseGUI gui) {
        log.info("Initializing GUI ...");
        CurrentGui.getInstance().setGui(gui);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        gui.initGUI();
        log.info("GUI initialized");
    }

    public void setPropertyPanelToGridElement(final GridElement e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.setPropertyPanelToGridElementHelper(e);
            }
        });
    }

    private void setPropertyPanelToGridElementHelper(GridElement e) {
        this.editedGridElement = e;
        OwnSyntaxPane propertyPane = CurrentGui.getInstance().getGui().getPropertyPane();
        if (e != null) {
            propertyPane.switchToElement(e);
        } else {
            DiagramHandler handler = CurrentDiagram.getInstance().getDiagramHandler();
            if (handler == null) {
                propertyPane.switchToNonElement("");
            } else {
                propertyPane.switchToNonElement(handler.getHelpText());
            }
        }
    }

    public void doNew() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.doNewHelper();
            }
        });
    }

    private void doNewHelper() {
        if (this.lastTabIsEmpty()) {
            return;
        }
        DiagramHandler diagram = new DiagramHandler(null);
        this.diagrams.add(diagram);
        CurrentGui.getInstance().getGui().open(diagram);
        if (this.diagrams.size() == 1) {
            this.setPropertyPanelToGridElement(null);
        }
    }

    public void doOpenFromFileChooser() {
        List<String> files = new OpenFileChooser().getFilesToOpen(CurrentGui.getInstance().getGui().getMainFrame());
        for (String file : files) {
            this.doOpen(file);
        }
    }

    @Override
    public void doOpen(final String filename) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.doOpenHelper(filename);
            }
        });
    }

    private void doOpenHelper(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            Notifier.getInstance().showError(filename + " does not exist");
            return;
        }
        Config.getInstance().setOpenFileHome(file.getParent());
        DiagramHandler handler = this.getDiagramHandlerForFile(filename);
        if (handler != null) {
            CurrentGui.getInstance().getGui().jumpTo(handler);
            Notifier.getInstance().showInfo("switched to " + filename);
        } else {
            if (this.lastTabIsEmpty()) {
                this.diagrams.get(this.diagrams.size() - 1).doClose();
            }
            this.editedGridElement = null;
            DiagramHandler diagram = new DiagramHandler(file);
            this.diagrams.add(diagram);
            CurrentGui.getInstance().getGui().open(diagram);
            if (this.diagrams.size() == 1) {
                this.setPropertyPanelToGridElement(null);
            }
            RecentlyUsedFilesList.getInstance().add(filename);
            Notifier.getInstance().showInfo(filename + " opened");
        }
    }

    private DiagramHandler getDiagramHandlerForFile(String file) {
        for (DiagramHandler d : this.diagrams) {
            if (!d.getFullPathName().equalsIgnoreCase(file)) continue;
            return d;
        }
        return null;
    }

    private boolean lastTabIsEmpty() {
        DiagramHandler lastDiagram;
        return !this.diagrams.isEmpty() && (lastDiagram = this.diagrams.get(this.diagrams.size() - 1)).getController().isEmpty() && lastDiagram.getDrawPanel().getGridElements().isEmpty();
    }

    @Override
    public void closeProgram() {
        ConfigHandler.saveConfig(CurrentGui.getInstance().getGui());
    }

    public TreeMap<String, PaletteHandler> getPalettes() {
        if (this.palettes == null) {
            this.palettes = new TreeMap(Constants.DEFAULT_FIRST_COMPARATOR);
            List<File> palettes = this.scanForPalettes();
            for (File palette : palettes) {
                this.palettes.put(this.getFilenameWithoutExtension(palette), new PaletteHandler(palette));
            }
        }
        return this.palettes;
    }

    private String getFilenameWithoutExtension(File file) {
        return file.getName().substring(0, file.getName().indexOf("."));
    }

    private List<File> scanForPalettes() {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File[] paletteFiles = fileSystemView.getFiles(new File(Path.homeProgram() + "palettes/"), false);
        ArrayList<File> palettes = new ArrayList<File>();
        for (File palette : paletteFiles) {
            if (!palette.getName().endsWith("." + Program.getInstance().getExtension())) continue;
            palettes.add(palette);
        }
        return palettes;
    }

    public List<String> getTemplateNames() {
        File[] templateFiles;
        ArrayList<String> templates = new ArrayList<String>();
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        for (File template : templateFiles = fileSystemView.getFiles(new File(Path.customElements()), false)) {
            if (!template.getName().endsWith(".java")) continue;
            templates.add(template.getName().substring(0, template.getName().length() - 5));
        }
        Collections.sort(templates, Constants.DEFAULT_FIRST_COMPARATOR);
        return templates;
    }

    public List<DiagramHandler> getDiagrams() {
        return this.diagrams;
    }

    public Collection<DiagramHandler> getDiagramsAndPalettes() {
        ArrayList<DiagramHandler> returnList = new ArrayList<DiagramHandler>(this.getDiagrams());
        returnList.addAll(this.getPalettes().values());
        return returnList;
    }

    public GridElement getEditedGridElement() {
        return this.editedGridElement;
    }

    public PaletteHandler getPalette() {
        String name = CurrentGui.getInstance().getGui().getSelectedPalette();
        if (name != null) {
            return this.getPalettes().get(name);
        }
        return null;
    }
}

