/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.httputils;

import java.util.ArrayList;
import java.util.List;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.httputils.HtmlContext;

public class HtmlContextAnalyser {
    private char[] quotes = new char[]{'\'', '\"'};
    private String[] scriptAttributes = new String[]{"onBlur", "onChange", "onClick", "onDblClick", "onFocus", "onKeydown", "onKeyup", "onKeypress", "onLoad", "onMousedown", "onMouseup", "onMouseover", "onMousemove", "onMouseout", "onReset", "onSelect", "onSubmit", "onUnload"};
    private String[] urlAttributes = new String[]{"action", "background", "cite", "classid", "codebase", "data", "formaction", "href", "icon", "longdesc", "manifest", "poster", "profile", "src", "usemap"};
    private String[] tagsWithSrcAttributes = new String[]{"frame", "iframe", "img", "input", "script", "src"};
    private HttpMessage msg = null;
    private String htmlPage = null;
    private Source src = null;

    public HtmlContextAnalyser(HttpMessage httpMessage) {
        this.msg = httpMessage;
        this.htmlPage = httpMessage.getResponseHeader().toString() + httpMessage.getResponseBody().toString();
        this.src = new Source((CharSequence)this.htmlPage);
        this.src.fullSequentialParse();
    }

    private boolean isQuote(char c) {
        for (int i = 0; i < this.quotes.length; ++i) {
            if (c != this.quotes[i]) continue;
            return true;
        }
        return false;
    }

    private boolean isScriptAttribute(String string) {
        for (int i = 0; i < this.scriptAttributes.length; ++i) {
            if (!string.equalsIgnoreCase(this.scriptAttributes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isUrlAttribute(String string) {
        for (int i = 0; i < this.urlAttributes.length; ++i) {
            if (!string.equalsIgnoreCase(this.urlAttributes[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isInTagWithSrcAttribute(String string) {
        for (int i = 0; i < this.tagsWithSrcAttributes.length; ++i) {
            if (!string.equalsIgnoreCase(this.tagsWithSrcAttributes[i])) continue;
            return true;
        }
        return false;
    }

    public List<HtmlContext> getHtmlContexts(String string) {
        return this.getHtmlContexts(string, null, 0);
    }

    public List<HtmlContext> getHtmlContexts(String string, HtmlContext htmlContext, int n) {
        ArrayList<HtmlContext> arrayList = new ArrayList<HtmlContext>();
        int n2 = 0;
        while ((n2 = this.htmlPage.indexOf(string, n2)) >= 0) {
            Element element;
            String string2;
            char c;
            int n3;
            HtmlContext htmlContext2 = new HtmlContext(this.msg, string, n2, n2 + string.length());
            n2 += string.length();
            char c2 = '\u0000';
            for (n3 = htmlContext2.getStart() - 1; n3 > 0; --n3) {
                c = this.htmlPage.charAt(n3);
                if (this.isQuote(c)) {
                    c2 = c;
                    break;
                }
                if (c == '>') break;
            }
            if (c2 != '\u0000') {
                for (n3 = htmlContext2.getEnd(); n3 < this.htmlPage.length(); ++n3) {
                    c = this.htmlPage.charAt(n3);
                    if (c2 == c) {
                        htmlContext2.setSurroundingQuote("" + c2);
                        break;
                    }
                    if (this.isQuote(c) || c == '<') break;
                }
            }
            if ((string2 = this.htmlPage.substring(0, htmlContext2.getStart())).lastIndexOf("<!--") > string2.lastIndexOf(">")) {
                htmlContext2.setHtmlComment(true);
            }
            if ((element = this.src.getEnclosingElement(htmlContext2.getStart())) != null) {
                boolean bl = element.getName().equalsIgnoreCase("input");
                boolean bl2 = false;
                for (Attribute attribute : element.getAttributes()) {
                    if (attribute.getValue() != null && attribute.getValue().toLowerCase().indexOf(string.toLowerCase()) >= 0) {
                        htmlContext2.setTagAttribute(attribute.getName());
                        htmlContext2.setInUrlAttribute(this.isUrlAttribute(attribute.getName()));
                        htmlContext2.setInScriptAttribute(this.isScriptAttribute(attribute.getName()));
                    }
                    if (!bl || !attribute.getName().equalsIgnoreCase("type") || !"image".equalsIgnoreCase(attribute.getValue())) continue;
                    bl2 = true;
                }
                htmlContext2.addParentTag(element.getName());
                if (!bl || bl2) {
                    htmlContext2.setInTagWithSrc(this.isInTagWithSrcAttribute(element.getName()));
                }
                while ((element = element.getParentElement()) != null) {
                    htmlContext2.addParentTag(element.getName());
                }
            }
            if (htmlContext == null) {
                arrayList.add(htmlContext2);
                continue;
            }
            if (!htmlContext.matches(htmlContext2, n)) continue;
            arrayList.add(htmlContext2);
        }
        return arrayList;
    }
}

