/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.prefs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.owasp.jbrofuzz.JBroFuzz;
import org.owasp.jbrofuzz.system.Logger;
import org.owasp.jbrofuzz.ui.prefs.AbstractPrefsPanel;
import org.owasp.jbrofuzz.ui.prefs.PrefDialog;
import org.owasp.jbrofuzz.version.JBroFuzzPrefs;

class DirsPPanel
extends AbstractPrefsPanel {
    private static final long serialVersionUID = 8224780932033125038L;
    private final JTextField dirTextField;
    private final PrefDialog dialog;
    private final JCheckBox dirBox;

    protected DirsPPanel(final PrefDialog dialog) {
        super("Directory Locations");
        this.dialog = dialog;
        String dir = dialog.getJBroFuzzWindow().getJBroFuzz().getStorageHandler().getLocationCanonicalPath();
        JPanel dirPanel = new JPanel();
        dirPanel.setLayout(new BoxLayout(dirPanel, 2));
        dirPanel.setAlignmentX(0.0f);
        boolean boolEntry = JBroFuzz.PREFS.getBoolean(JBroFuzzPrefs.DIRS[1].getId(), true);
        this.dirBox = new JCheckBox(JBroFuzzPrefs.DIRS[1].getTitle(), boolEntry);
        this.dirBox.setToolTipText(JBroFuzzPrefs.DIRS[1].getTooltip());
        this.dirBox.setBorderPaintedFlat(true);
        this.add(this.dirBox);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        dirPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(JBroFuzzPrefs.DIRS[0].getTitle()), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        dirPanel.setToolTipText(JBroFuzzPrefs.DIRS[0].getTooltip());
        this.dirTextField = new JTextField(dir);
        this.dirTextField.setFont(new Font("Verdana", 0, 12));
        this.dirTextField.setMargin(new Insets(1, 1, 1, 1));
        final JButton browseDirButton = new JButton("Browse");
        browseDirButton.setAlignmentX(0.5f);
        browseDirButton.setEnabled(true);
        dirPanel.add((Component)this.dirTextField, "North");
        dirPanel.add(browseDirButton);
        this.add(dirPanel);
        this.add(Box.createRigidArea(new Dimension(0, 300)));
        if (boolEntry) {
            browseDirButton.setEnabled(true);
            this.dirTextField.setEnabled(true);
        } else {
            browseDirButton.setEnabled(false);
            this.dirTextField.setEnabled(false);
        }
        this.dirBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DirsPPanel.this.dirBox.isSelected()) {
                    browseDirButton.setEnabled(true);
                    DirsPPanel.this.dirTextField.setEnabled(true);
                } else {
                    browseDirButton.setEnabled(false);
                    DirsPPanel.this.dirTextField.setEnabled(false);
                }
                dialog.setApplyEnabled(true);
            }
        });
        browseDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        File selDirFile;
                        JFileChooser chooserD = new JFileChooser();
                        chooserD.setCurrentDirectory(new File("."));
                        chooserD.setDialogTitle(JBroFuzzPrefs.DIRS[0].getTooltip());
                        chooserD.setFileSelectionMode(1);
                        chooserD.setAcceptAllFileFilterUsed(false);
                        if (chooserD.showOpenDialog(dialog) == 0 && (selDirFile = chooserD.getSelectedFile()).isDirectory()) {
                            try {
                                DirsPPanel.this.dirTextField.setText(selDirFile.getCanonicalPath());
                            }
                            catch (IOException e) {
                                Logger.log(e.getMessage(), 4);
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public void apply() {
        JBroFuzz.PREFS.put(JBroFuzzPrefs.DIRS[0].getId(), this.dirTextField.getText());
        if (this.dirBox.isSelected()) {
            JBroFuzz.PREFS.putBoolean(JBroFuzzPrefs.DIRS[1].getId(), true);
            this.dialog.getJBroFuzzWindow().getJBroFuzz().getStorageHandler().createNewLocation();
            this.dirTextField.setText(this.dialog.getJBroFuzzWindow().getJBroFuzz().getStorageHandler().getLocationCanonicalPath());
        } else {
            JBroFuzz.PREFS.putBoolean(JBroFuzzPrefs.DIRS[1].getId(), false);
        }
    }
}

