/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.payloads;

import javax.swing.BorderFactory;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.owasp.jbrofuzz.payloads.PayloadsPanel;

final class FuzzersRowListener
implements ListSelectionListener {
    private final PayloadsPanel payloadsPanel;

    FuzzersRowListener(PayloadsPanel payloadsPanel) {
        this.payloadsPanel = payloadsPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        String name;
        if (event.getValueIsAdjusting()) {
            return;
        }
        int d = this.payloadsPanel.fuzzersTable.getSelectedRow();
        try {
            d = this.payloadsPanel.fuzzersTable.convertRowIndexToModel(d);
            name = (String)this.payloadsPanel.fuzzersTableModel.getValueAt(d, 0);
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        String id = this.payloadsPanel.getFrame().getJBroFuzz().getDatabase().getIdFromName(name);
        this.payloadsPanel.payloadsTableModel.setData(this.payloadsPanel.getFrame().getJBroFuzz().getDatabase().getPayloads(id));
        if (this.payloadsPanel.payloadsTableModel.getRowCount() >= 0) {
            this.payloadsPanel.payloadsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(" " + name + " - " + id + " "), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            this.payloadsPanel.fuzzerInfoTextArea.setText("\nFuzzer Name: " + name + "\n" + "Fuzzer Type: " + this.payloadsPanel.getFrame().getJBroFuzz().getDatabase().getPrototype(id).getType() + "\n" + "Fuzzer Id:   " + id + "\n\n" + "Total Number of Payloads: " + this.payloadsPanel.getFrame().getJBroFuzz().getDatabase().getSize(id));
            this.payloadsPanel.fuzzerInfoTextArea.setCaretPosition(this.payloadsPanel.fuzzerInfoTextArea.getText().length());
        }
        this.payloadsPanel.payloadInfoTextArea.setText("");
        this.payloadsPanel.payloadInfoTextArea.setCaretPosition(0);
    }
}

