/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.anticsrf;

import java.util.List;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.anticsrf.AntiCsrfToken;
import org.zaproxy.zap.extension.anticsrf.ExtensionAntiCSRF;
import org.zaproxy.zap.extension.pscan.PassiveScanThread;
import org.zaproxy.zap.extension.pscan.PassiveScanner;

public class AntiCsrfDetectScanner
implements PassiveScanner {
    private PassiveScanThread parent = null;
    private final ExtensionAntiCSRF extAntiCSRF;

    public AntiCsrfDetectScanner(ExtensionAntiCSRF extensionAntiCSRF) {
        this.extAntiCSRF = extensionAntiCSRF;
    }

    @Override
    public void setParent(PassiveScanThread passiveScanThread) {
        this.parent = passiveScanThread;
    }

    @Override
    public void scanHttpRequestSend(HttpMessage httpMessage, int n) {
    }

    @Override
    public void scanHttpResponseReceive(HttpMessage httpMessage, int n, Source source) {
        List<AntiCsrfToken> list = this.extAntiCSRF.getTokensFromResponse(httpMessage, source);
        for (AntiCsrfToken antiCsrfToken : list) {
            if (this.parent != null) {
                this.parent.addTag(n, "AntiCSRF");
            }
            this.extAntiCSRF.registerAntiCsrfToken(antiCsrfToken);
        }
    }

    @Override
    public String getName() {
        return "Anti CSRF Token Detection";
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean bl) {
    }

    @Override
    public Plugin.AlertThreshold getLevel() {
        return Plugin.AlertThreshold.MEDIUM;
    }

    @Override
    public void setLevel(Plugin.AlertThreshold alertThreshold) {
    }
}

