/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.FormControl;
import net.htmlparser.jericho.FormControlType;
import net.htmlparser.jericho.FormField;
import net.htmlparser.jericho.FormFields;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.URLCanonicalizer;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderHtmlFormParser
extends SpiderParser {
    private static final String ENCODING_TYPE = "UTF-8";
    private static final String DEFAULT_NUMBER_VALUE = "1";
    private static final String DEFAULT_FILE_VALUE = "test_file.txt";
    private static final String DEFAULT_TEXT_VALUE = "ZAP";
    private static final String METHOD_POST = "POST";
    private static final String ATTR_TYPE = "type";
    private static final String DEFAULT_EMPTY_VALUE = "";
    private static final String DEFAULT_PASS_VALUE = "ZAP";
    SpiderParam param;

    public SpiderHtmlFormParser(SpiderParam spiderParam) {
        this.param = spiderParam;
    }

    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        log.debug((Object)"Parsing an HTML message for forms...");
        if (!this.param.isProcessForm()) {
            return false;
        }
        if (source == null) {
            source = new Source((CharSequence)httpMessage.getResponseBody().toString());
        }
        String string = httpMessage == null ? DEFAULT_EMPTY_VALUE : httpMessage.getRequestHeader().getURI().toString();
        Element element = source.getFirstElement("base");
        if (element != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Base tag was found in HTML: " + element.getDebugInfo()));
            }
            if (element.getAttributeValue("href") != null) {
                string = element.getAttributeValue("href");
            }
        }
        List list = source.getAllElements("form");
        for (Element element2 : list) {
            String string2;
            String string3 = element2.getAttributeValue("method");
            String string4 = element2.getAttributeValue("action");
            log.debug((Object)("Found new form with method: '" + string3 + "' and action: " + string4));
            if (string4 == null) {
                log.debug((Object)("No form 'action' defined. Using base URL: " + string));
                string4 = string;
            }
            if (!this.param.isPostForm() && string3 != null && string3.trim().equalsIgnoreCase(METHOD_POST)) {
                log.debug((Object)"Skipping form with POST method because of user settings.");
                continue;
            }
            List<HtmlParameter> list2 = this.prepareFormDataSet(element2.getFormFields());
            if (string3 != null && string3.trim().equalsIgnoreCase(METHOD_POST)) {
                string2 = DEFAULT_EMPTY_VALUE;
                string2 = this.buildEncodedUrlQuery(list2);
                log.debug((Object)("Submiting form with POST method and message body with form parameters (normal encoding): " + string2));
                String string5 = URLCanonicalizer.getCanonicalURL(string4, string);
                if (string5 == null) {
                    return false;
                }
                log.debug((Object)("Canonical URL constructed using '" + string4 + "': " + string5));
                this.notifyListenersPostResourceFound(httpMessage, n + 1, string5, string2);
                continue;
            }
            string2 = this.buildEncodedUrlQuery(list2);
            log.debug((Object)("Submiting form with GET method and query with form parameters: " + string2));
            if (string4.contains("#")) {
                int n2 = string4.lastIndexOf("#");
                string4 = string4.substring(0, n2);
            }
            if (string4.contains("?")) {
                if (string4.endsWith("?")) {
                    this.processURL(httpMessage, n, string4 + string2, string);
                    continue;
                }
                this.processURL(httpMessage, n, string4 + "&" + string2, string);
                continue;
            }
            this.processURL(httpMessage, n, string4 + "?" + string2, string);
        }
        return false;
    }

    private List<HtmlParameter> prepareFormDataSet(FormFields formFields) {
        LinkedList<HtmlParameter> linkedList = new LinkedList<HtmlParameter>();
        for (FormField formField : formFields) {
            Object object;
            if (log.isDebugEnabled()) {
                log.debug((Object)("New form field: " + formField.getDebugInfo()));
            }
            List list = formField.getValues();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Existing values: " + list));
            }
            if (list.isEmpty() || list.size() == 1 && ((String)list.get(0)).isEmpty()) {
                Object object2 = DEFAULT_EMPTY_VALUE;
                Object object3 = formField.getPredefinedValues();
                if (!object3.isEmpty()) {
                    object = object3.iterator();
                    object2 = (String)object.next();
                    if (object.hasNext()) {
                        object2 = (String)object.next();
                    }
                } else if (formField.getUserValueCount() > 0) {
                    object2 = this.getDefaultTextValue(formField);
                }
                log.debug((Object)("No existing value for field " + formField.getName() + ". Generated: " + (String)object2));
                object = new HtmlParameter(HtmlParameter.Type.form, formField.getName(), (String)object2);
                linkedList.add((HtmlParameter)object);
                continue;
            }
            for (Object object3 : list) {
                object = new HtmlParameter(HtmlParameter.Type.form, formField.getName(), (String)object3);
                linkedList.add((HtmlParameter)object);
            }
        }
        return linkedList;
    }

    private String getDefaultTextValue(FormField formField) {
        FormControl formControl = formField.getFormControl();
        if (formControl.getFormControlType() == FormControlType.TEXT) {
            String string = (String)formControl.getAttributesMap().get(ATTR_TYPE);
            if (string == null || string.equalsIgnoreCase("text")) {
                return "ZAP";
            }
            if (string.equalsIgnoreCase("number") || string.equalsIgnoreCase("range")) {
                String string2 = (String)formControl.getAttributesMap().get("min");
                if (string2 != null) {
                    return string2;
                }
                String string3 = (String)formControl.getAttributesMap().get("min");
                if (string3 != null) {
                    return string3;
                }
                return DEFAULT_NUMBER_VALUE;
            }
            if (string.equalsIgnoreCase("url")) {
                return "http://www.example.com";
            }
            if (string.equalsIgnoreCase("email")) {
                return "foo-bar@example.com";
            }
            if (string.equalsIgnoreCase("color")) {
                return "#ffffff";
            }
            if (string.equalsIgnoreCase("tel")) {
                return "9999999999";
            }
            if (string.equalsIgnoreCase("datetime")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                return simpleDateFormat.format(new Date());
            }
            if (string.equalsIgnoreCase("datetime-local")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                return simpleDateFormat.format(new Date());
            }
            if (string.equalsIgnoreCase("date")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                return simpleDateFormat.format(new Date());
            }
            if (string.equalsIgnoreCase("time")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
                return simpleDateFormat.format(new Date());
            }
            if (string.equalsIgnoreCase("month")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
                return simpleDateFormat.format(new Date());
            }
            if (string.equalsIgnoreCase("week")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-'W'ww");
                return simpleDateFormat.format(new Date());
            }
        } else {
            if (formControl.getFormControlType() == FormControlType.PASSWORD) {
                return "ZAP";
            }
            if (formControl.getFormControlType() == FormControlType.FILE) {
                return DEFAULT_FILE_VALUE;
            }
        }
        return DEFAULT_EMPTY_VALUE;
    }

    private String buildEncodedUrlQuery(List<HtmlParameter> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (HtmlParameter htmlParameter : list) {
            try {
                String string = URLEncoder.encode(htmlParameter.getName(), ENCODING_TYPE);
                stringBuilder.append(string);
                stringBuilder.append("=");
                string = URLEncoder.encode(htmlParameter.getValue(), ENCODING_TYPE);
                stringBuilder.append(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                log.warn((Object)"Error while encoding query for form.", (Throwable)unsupportedEncodingException);
            }
            stringBuilder.append("&");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        return !bl && httpMessage.getResponseHeader() != null && httpMessage.getResponseHeader().isHtml();
    }
}

